/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr;

import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.search.SolrIndexSearcher;

public abstract class FeatureLogger {
    private final String fvCacheName;
    protected final FeatureFormat featureFormat;

    protected FeatureLogger(String fvCacheName, FeatureFormat f) {
        this.fvCacheName = fvCacheName;
        this.featureFormat = f;
    }

    public boolean log(int docid, LTRScoringQuery scoringQuery, SolrIndexSearcher searcher, LTRScoringQuery.FeatureInfo[] featuresInfo) {
        String featureVector = this.makeFeatureVector(featuresInfo);
        if (featureVector == null) {
            return false;
        }
        return searcher.cacheInsert(this.fvCacheName, (Object)FeatureLogger.fvCacheKey(scoringQuery, docid), (Object)featureVector) != null;
    }

    public abstract String makeFeatureVector(LTRScoringQuery.FeatureInfo[] var1);

    private static int fvCacheKey(LTRScoringQuery scoringQuery, int docid) {
        return scoringQuery.hashCode() + 31 * docid;
    }

    public String getFeatureVector(int docid, LTRScoringQuery scoringQuery, SolrIndexSearcher searcher) {
        return (String)searcher.cacheLookup(this.fvCacheName, (Object)FeatureLogger.fvCacheKey(scoringQuery, docid));
    }

    public static enum FeatureFormat {
        DENSE,
        SPARSE;

    }
}

