/*
 * Decompiled with CFR 0.152.
 */
package org.krummas.junit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.util.Watchdog;

public class JStackJUnitTask
extends JUnitTask {
    private Integer timeout;

    public void setTimeout(Integer n) {
        this.timeout = n;
        super.setTimeout(n);
    }

    public ExecuteWatchdog createWatchdog() throws BuildException {
        return new JStackWatchDog(this.timeout);
    }

    private static class JStackWatchDog
    extends ExecuteWatchdog {
        private long pid;

        public JStackWatchDog(long l) {
            super(l);
        }

        public JStackWatchDog(int n) {
            super(n);
        }

        public synchronized void start(Process process) {
            this.pid = this.getPid(process);
            super.start(process);
        }

        public synchronized void timeoutOccured(Watchdog watchdog) {
            if (this.pid > 0L) {
                ProcessBuilder processBuilder = new ProcessBuilder("jstack", "-l", String.valueOf(this.pid));
                try {
                    Process process = processBuilder.start();
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String string;
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((string = bufferedReader.readLine()) != null) {
                            stringBuilder.append(string).append("\n");
                        }
                        System.out.println(stringBuilder.toString());
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Could not get stack for " + this.pid);
                    iOException.printStackTrace();
                }
            }
            super.timeoutOccured(watchdog);
        }

        private long getPid(Process process) {
            if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
                try {
                    Field field = process.getClass().getDeclaredField("pid");
                    field.setAccessible(true);
                    long l = field.getLong(process);
                    field.setAccessible(false);
                    return l;
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    System.err.println("Could not get PID");
                }
            }
            return -1L;
        }
    }
}

