/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.predefined;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.predefined.PredefinedOperation;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.stress.util.Timer;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.utils.FBUtilities;

public final class ThriftInserter
extends PredefinedOperation {
    public ThriftInserter(Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        super(Command.WRITE, timer, generator, seedManager, settings);
    }

    @Override
    public boolean isWrite() {
        return true;
    }

    @Override
    public void run(final ThriftClient client) throws IOException {
        ByteBuffer key = this.getKey();
        List<Column> columns = this.getColumns();
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(columns.size());
        for (Column c : columns) {
            ColumnOrSuperColumn column = new ColumnOrSuperColumn().setColumn(c);
            mutations.add(new Mutation().setColumn_or_supercolumn(column));
        }
        Map row = Collections.singletonMap(this.type.table, mutations);
        final Map record = Collections.singletonMap(key, row);
        this.timeWithRetry(new Operation.RunOp(){

            @Override
            public boolean run() throws Exception {
                client.batch_mutate(record, ThriftInserter.this.settings.command.consistencyLevel);
                return true;
            }

            @Override
            public int partitionCount() {
                return 1;
            }

            @Override
            public int rowCount() {
                return 1;
            }
        });
    }

    protected List<Column> getColumns() {
        PredefinedOperation.ColumnSelection selection = this.select();
        List<ByteBuffer> values = this.getColumnValues(selection);
        ArrayList<Column> columns = new ArrayList<Column>(values.size());
        List<ByteBuffer> names = this.select().select(this.settings.columns.names);
        for (int i = 0; i < values.size(); ++i) {
            columns.add(new Column(names.get(i)).setValue(values.get(i)).setTimestamp(this.settings.columns.timestamp != null ? Long.parseLong(this.settings.columns.timestamp) : FBUtilities.timestampMicros()));
        }
        return columns;
    }
}

