/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmpp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.util.stax.JDOMStreamReader;
import org.codehaus.xfire.xmpp.SoapEnvelopePacket;
import org.codehaus.xfire.xmpp.XMPPChannel;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Packet;

public class ChannelPacketListener
implements PacketListener {
    private static Log log = LogFactory.getLog((Class)ChannelPacketListener.class);
    private XMPPChannel channel;
    public static final String PACKET = "xmpp.packet";
    private XFire xfire;

    public ChannelPacketListener(XFire xfire, XMPPChannel channel) {
        this.xfire = xfire;
        this.channel = channel;
    }

    public void processPacket(Packet packet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got packet: " + packet.getClass().getName()));
        }
        if (!(packet instanceof SoapEnvelopePacket)) {
            return;
        }
        SoapEnvelopePacket soapPacket = (SoapEnvelopePacket)packet;
        String to = packet.getTo();
        String serviceName = to.substring(to.indexOf(47) + 1);
        Service service = this.xfire.getServiceRegistry().getService(serviceName);
        InMessage message = new InMessage(new JDOMStreamReader(soapPacket.getDocument().getRootElement()), to);
        MessageContext context = new MessageContext();
        context.setProperty(PACKET, packet);
        context.setXFire(this.xfire);
        context.setService(service);
        this.channel.receive(context, message);
    }
}

