/*****
 NAME
	tgtk.h - type definition for Widget classes
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#if !defined(TGTK_H_INCLUDED)
#define TGTK_H_INCLUDED

#include <gtk/gtk.h>
#include <coconut/tgraphics.h>

typedef enum {
	widget_unknown	= 0,
	widget_arrow,
	widget_button,
	widget_calendar,
	widget_checkbutton,
	widget_container,
	widget_frame,
	widget_label,
	widget_radiobutton,
	widget_separator,
	widget_textview,
	widget_window
} widget_t ;

typedef enum {
	window_toplevel	= GTK_WINDOW_TOPLEVEL,
	window_popup	= GTK_WINDOW_POPUP
} window_t ;
#define	windowType2Gtk(typ)	((GtkWindowType) typ)

typedef enum {
	screen_align_free		= GTK_WIN_POS_NONE,
	screen_align_center		= GTK_WIN_POS_CENTER,
	screen_align_mouse		= GTK_WIN_POS_MOUSE,
	screen_align_always_center	= GTK_WIN_POS_CENTER_ALWAYS
} screen_align_t ;
#define screenAlignType2Gtk(typ) ((GtkWindowType) typ)

typedef enum {
	justify_left = GTK_JUSTIFY_LEFT,
	justify_right = GTK_JUSTIFY_RIGHT,
	justify_center = GTK_JUSTIFY_CENTER,
	justify_fill = GTK_JUSTIFY_FILL
} justification_t ;

typedef enum {
	dir_up		= GTK_ARROW_UP,
	dir_down	= GTK_ARROW_DOWN,
	dir_left	= GTK_ARROW_LEFT,
	dir_right	= GTK_ARROW_RIGHT
} direction_t ;
#define	IS_VERT_DIR(D)		((D) == dir_down || (D) == dir_up)
#define	DIR2GTKARROW(D)		((GtkArrowType) D)
#define	GTKARROW2DIR(A)		((direction_t) A)

typedef enum {
	shadow_none		= GTK_SHADOW_NONE,
	shadow_in		= GTK_SHADOW_IN,
	shadow_out		= GTK_SHADOW_OUT,
	shadow_etched_in	= GTK_SHADOW_ETCHED_IN,
	shadow_etched_out	= GTK_SHADOW_ETCHED_OUT
} shadow_t ;
#define	SHADOW2GTK(TYP)	((GtkArrowType) TYP)
#define	GTK2SHADOW(TYP)	((shadow_t) TYP)

#endif /* !defined(TGTK_H_INCLUDED) */

