/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.impl;

import edu.umd.marbl.mhap.impl.FastaData;
import edu.umd.marbl.mhap.impl.MhapRuntimeException;
import edu.umd.marbl.mhap.impl.Sequence;
import edu.umd.marbl.mhap.impl.SequenceSketch;
import edu.umd.marbl.mhap.sketch.FrequencyCounts;
import edu.umd.marbl.mhap.sketch.ZeroNGramsFoundException;
import edu.umd.marbl.mhap.utils.ReadBuffer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SequenceSketchStreamer {
    private final DataInputStream buffInput;
    private final FastaData fastaData;
    private final FrequencyCounts kmerFilter;
    private final int kmerSize;
    private final int minOlapLength;
    private final AtomicLong numberProcessed;
    private final int numHashes;
    private final int offset;
    private final int orderedKmerSize;
    private final int orderedSketchSize;
    private boolean readClosed;
    private boolean doReverseCompliment;
    private final boolean readingFasta;
    private final double repeatWeight;
    private final ConcurrentLinkedQueue<SequenceSketch> sequenceHashList;

    public SequenceSketchStreamer(String file, int minOlapLength, int offset) throws FileNotFoundException {
        this.fastaData = null;
        this.readingFasta = false;
        this.sequenceHashList = new ConcurrentLinkedQueue();
        this.numberProcessed = new AtomicLong();
        this.kmerFilter = null;
        this.repeatWeight = 0.0;
        this.minOlapLength = minOlapLength;
        this.doReverseCompliment = false;
        this.kmerSize = 0;
        this.numHashes = 0;
        this.orderedKmerSize = 0;
        this.orderedSketchSize = 0;
        this.readClosed = false;
        this.offset = offset;
        this.buffInput = new DataInputStream(new BufferedInputStream(new FileInputStream(file), 0x800000));
    }

    public SequenceSketchStreamer(String file, int minOlapLength, int kmerSize, int numHashes, int orderedKmerSize, int orderedSketchSize, FrequencyCounts kmerFilter, boolean doReverseCompliment, double repeatWeight, int offset) throws IOException {
        this.fastaData = new FastaData(file, offset);
        this.readingFasta = true;
        this.sequenceHashList = new ConcurrentLinkedQueue();
        this.numberProcessed = new AtomicLong();
        this.repeatWeight = repeatWeight;
        this.minOlapLength = minOlapLength;
        this.doReverseCompliment = doReverseCompliment;
        this.kmerFilter = kmerFilter;
        this.kmerSize = kmerSize;
        this.numHashes = numHashes;
        this.orderedKmerSize = orderedKmerSize;
        this.orderedSketchSize = orderedSketchSize;
        this.buffInput = null;
        this.readClosed = false;
        this.offset = offset;
    }

    public SequenceSketch dequeue(boolean fwdOnly, ReadBuffer buf) throws IOException {
        this.enqueueUntilFound(fwdOnly, buf);
        return this.sequenceHashList.poll();
    }

    private boolean enqueue(boolean fwdOnly, ReadBuffer buf) throws IOException, ZeroNGramsFoundException {
        if (this.readingFasta) {
            Sequence seq;
            while ((seq = this.fastaData.dequeue()) != null && seq.length() < this.minOlapLength) {
            }
            SequenceSketch seqHashes = null;
            if (seq != null) {
                seqHashes = this.getSketch(seq);
            }
            if (seqHashes == null) {
                return false;
            }
            this.processAddition(seqHashes);
            this.sequenceHashList.add(seqHashes);
            if (!fwdOnly) {
                seqHashes = this.getSketch(seq.getReverseCompliment());
                this.sequenceHashList.add(seqHashes);
                this.processAddition(seqHashes);
            }
        } else {
            SequenceSketch seqHashes = this.readFromBinary(buf, fwdOnly);
            while (seqHashes != null && fwdOnly && !seqHashes.getSequenceId().isForward() && seqHashes.getSequenceLength() < this.minOlapLength) {
                seqHashes = this.readFromBinary(buf, fwdOnly);
            }
            if (seqHashes == null) {
                return false;
            }
            this.processAddition(seqHashes);
            this.sequenceHashList.add(seqHashes);
        }
        return true;
    }

    public synchronized void enqueueFullFile(final boolean fwdOnly, int numThreads) throws IOException {
        ExecutorService execSvc = Executors.newFixedThreadPool(numThreads);
        for (int iter = 0; iter < numThreads; ++iter) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    ReadBuffer buf = new ReadBuffer();
                    try {
                        while (SequenceSketchStreamer.this.enqueueUntilFound(fwdOnly, buf)) {
                        }
                    }
                    catch (IOException e) {
                        throw new MhapRuntimeException(e);
                    }
                }
            };
            execSvc.execute(task);
        }
        execSvc.shutdown();
        try {
            execSvc.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            execSvc.shutdownNow();
            throw new MhapRuntimeException("Unable to finish all tasks.");
        }
    }

    private boolean enqueueUntilFound(boolean fwdOnly, ReadBuffer buf) throws IOException {
        boolean getNext = true;
        boolean returnValue = false;
        while (getNext) {
            try {
                returnValue = this.enqueue(fwdOnly, buf);
                getNext = false;
            }
            catch (ZeroNGramsFoundException e) {
                System.err.println("Could not process sketch for a read because zero valid n-grams found: " + e.getSequenceString());
            }
        }
        return returnValue;
    }

    public Iterator<SequenceSketch> getDataIterator() {
        return this.sequenceHashList.iterator();
    }

    public int getFastaProcessed() {
        if (this.fastaData == null) {
            return 0;
        }
        return this.fastaData.getNumberProcessed();
    }

    public int getNumberProcessed() {
        return this.numberProcessed.intValue();
    }

    public SequenceSketch getSketch(Sequence seq) throws ZeroNGramsFoundException {
        return new SequenceSketch(seq, this.kmerSize, this.numHashes, this.orderedKmerSize, this.orderedSketchSize, this.kmerFilter, this.doReverseCompliment, this.repeatWeight);
    }

    protected void processAddition(SequenceSketch seqHashes) {
        this.numberProcessed.getAndIncrement();
        int numProcessed = this.getNumberProcessed();
        if (numProcessed % 5000 == 0) {
            System.err.println("Current # sequences loaded and processed from file: " + numProcessed + "...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SequenceSketch readFromBinary(ReadBuffer buf, boolean fwdOnly) throws IOException {
        byte[] byteArray = null;
        DataInputStream dataInputStream = this.buffInput;
        synchronized (dataInputStream) {
            if (this.readClosed) {
                return null;
            }
            try {
                boolean keepReading = true;
                while (keepReading) {
                    byte isFwd = this.buffInput.readByte();
                    if (!fwdOnly || isFwd == 1) {
                        keepReading = false;
                    }
                    int byteSize = this.buffInput.readInt();
                    byteArray = buf.getBuffer(byteSize);
                    this.buffInput.read(byteArray, 0, byteSize);
                }
            }
            catch (EOFException e) {
                this.buffInput.close();
                this.readClosed = true;
                return null;
            }
        }
        SequenceSketch seqHashes = SequenceSketch.fromByteStream(new DataInputStream(new ByteArrayInputStream(byteArray)), this.offset);
        return seqHashes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToBinary(String file, final boolean fwdOnly, int numThreads) throws IOException {
        try (OutputStream output = null;){
            final OutputStream finalOutput = output = new BufferedOutputStream(new FileOutputStream(file), 0x800000);
            ExecutorService execSvc = Executors.newFixedThreadPool(numThreads);
            for (int iter = 0; iter < numThreads; ++iter) {
                Runnable task = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ReadBuffer buf = new ReadBuffer();
                        try {
                            SequenceSketch seqHashes = SequenceSketchStreamer.this.dequeue(fwdOnly, buf);
                            while (seqHashes != null) {
                                byte[] byteArray = seqHashes.getAsByteArray();
                                int arraySize = byteArray.length;
                                byte isFwd = seqHashes.getSequenceId().isForward() ? (byte)1 : 0;
                                byte[] byteSize = ByteBuffer.allocate(5).put(isFwd).putInt(arraySize).array();
                                OutputStream outputStream = finalOutput;
                                synchronized (outputStream) {
                                    finalOutput.write(byteSize);
                                    finalOutput.write(byteArray);
                                }
                                seqHashes = SequenceSketchStreamer.this.dequeue(fwdOnly, buf);
                            }
                        }
                        catch (IOException e) {
                            throw new MhapRuntimeException(e);
                        }
                    }
                };
                execSvc.execute(task);
            }
            execSvc.shutdown();
            try {
                execSvc.awaitTermination(365L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                execSvc.shutdownNow();
                throw new MhapRuntimeException("Unable to finish all tasks.");
            }
            finalOutput.flush();
        }
    }
}

