# Print the new lines in a log file

# First arg is the log file, second is state file for remembering
# which lines have already been printed.

# Copyright (c) 2019 Andreas Gustafsson.  All rights reserved.
# Please refer to the file COPYRIGHT for detailed copyright information.

from __future__ import print_function

import os
import sys
import io # f
from utils import read_file, write_file

log_fn = sys.argv[1]
offset_fn = sys.argv[2]

if os.path.exists(offset_fn):
    offset = int(read_file(offset_fn, 't'))
else:
    offset = 0

log_f = io.open(log_fn, 'rb')
length = log_f.seek(0, 2)
if length < offset:
    offset = 0
log_f.seek(offset, 0)
data = log_f.read()
os.write(1, data)
offset = log_f.tell()
log_f.close()

write_file(offset_fn, str(offset), 't')

