/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.apache.activemq.apollo.broker.security.EncryptionSupport$;
import org.apache.activemq.apollo.dto.BrokerDTO;
import org.apache.activemq.apollo.dto.VirtualHostDTO;
import org.apache.activemq.apollo.dto.XmlCodec;
import org.apache.activemq.apollo.util.FileSupport$;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigStore$
implements ScalaObject {
    public static final ConfigStore$ MODULE$;

    static {
        new ConfigStore$();
    }

    public BrokerDTO load(File file$1, Function1<String, BoxedUnit> func) {
        return this.load((Function0<InputStream>)new Serializable(file$1){
            public static final long serialVersionUID;
            private final File file$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final FileInputStream apply() {
                return new FileInputStream(this.file$1);
            }
            {
                this.file$1 = file;
            }
        }, this.config_properties(file$1), func);
    }

    public BrokerDTO load_xml(byte[] in$1, Function1<String, BoxedUnit> func) {
        return this.load((Function0<InputStream>)new Serializable(in$1){
            public static final long serialVersionUID;
            private final byte[] in$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ByteArrayInputStream apply() {
                return new ByteArrayInputStream(this.in$1);
            }
            {
                this.in$1 = byArray;
            }
        }, this.config_properties(null), func);
    }

    public BrokerDTO load(Function0<InputStream> is, Properties prop, Function1<String, BoxedUnit> func$1) {
        BrokerDTO rc = (BrokerDTO)XmlCodec.decode(BrokerDTO.class, (InputStream)((InputStream)is.apply()), (Properties)prop, (ValidationEventHandler)new ValidationEventHandler(func$1){
            private final Function1 func$1;

            public boolean handleEvent(ValidationEvent event) {
                String string;
                int n = event.getSeverity();
                switch (n) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                    case 0: {
                        string = "warning";
                        break;
                    }
                    case 2: {
                        string = "fatal error";
                        break;
                    }
                    case 1: {
                        string = "error";
                    }
                }
                String level = string;
                this.func$1.apply((Object)Predef$.MODULE$.augmentString("%s at (%d:%d): %s ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{level, BoxesRunTime.boxToInteger((int)event.getLocator().getLineNumber()), BoxesRunTime.boxToInteger((int)event.getLocator().getColumnNumber()), event.getMessage()})));
                return true;
            }
            {
                this.func$1 = function1;
            }
        });
        JavaConversions$.MODULE$.asScalaBuffer(rc.virtual_hosts).foreach((Function1)new Serializable(func$1){
            public static final long serialVersionUID;
            private final Function1 func$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(VirtualHostDTO host) {
                if (host.store == null) {
                    this.func$1.apply((Object)Predef$.MODULE$.augmentString("error: virtual host '%s' does not have valid store configured").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host.id})));
                }
            }
            {
                this.func$1 = function1;
            }
        });
        return rc;
    }

    /*
     * WARNING - void declaration
     */
    public Properties config_properties(File file) {
        void var2_2;
        File prop_file$1;
        Properties props$1 = new Properties();
        props$1.putAll((Map<?, ?>)System.getProperties());
        Object object = file == null ? BoxedUnit.UNIT : ((prop_file$1 = FileSupport$.MODULE$.to_rich_file(file.getParentFile()).$div(new StringBuilder().append((Object)file.getName()).append((Object)".properties").toString())).exists() ? FileSupport$.MODULE$.using((Closeable)new FileInputStream(prop_file$1), (Function1)new Serializable(props$1, prop_file$1){
            public static final long serialVersionUID;
            private final Properties props$1;
            private final File prop_file$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(FileInputStream is) {
                Properties p = new Properties();
                p.load(new FileInputStream(this.prop_file$1));
                this.props$1.putAll((Map<?, ?>)EncryptionSupport$.MODULE$.decrypt(p));
            }
            {
                this.props$1 = properties;
                this.prop_file$1 = file;
            }
        }) : BoxedUnit.UNIT);
        return var2_2;
    }

    private ConfigStore$() {
        MODULE$ = this;
    }
}

