/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.binaryop;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.tree.binaryop.BinaryOperatorExpression;

public class BooleanOrExpression
extends BinaryOperatorExpression {
    public BooleanOrExpression(JsonQuery lhs, JsonQuery rhs) {
        super(lhs, rhs, "or");
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode l : this.lhs.apply(scope, in)) {
            if (JsonNodeUtils.asBoolean(l)) {
                out.add((JsonNode)BooleanNode.TRUE);
                continue;
            }
            for (JsonNode r : this.rhs.apply(scope, in)) {
                out.add((JsonNode)BooleanNode.valueOf((boolean)JsonNodeUtils.asBoolean(r)));
            }
        }
        return out;
    }
}

