/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.PivotFacetHelper;
import org.apache.solr.handler.component.RangeFacetProcessor;
import org.apache.solr.handler.component.RangeFacetRequest;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.StatsComponent;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsInfo;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.PivotListEntry;

public class PivotFacetProcessor
extends SimpleFacets {
    public static final String QUERY = "query";
    public static final String RANGE = "range";
    protected SolrParams params;

    public PivotFacetProcessor(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        super(req, docs, params, rb);
        this.params = params;
    }

    public SimpleOrderedMap<List<NamedList<Object>>> process(String[] pivots) throws IOException {
        if (!this.rb.doFacets || pivots == null) {
            return null;
        }
        StatsInfo statsInfo = this.rb._statsInfo;
        SimpleOrderedMap pivotResponse = new SimpleOrderedMap();
        for (String pivotList : pivots) {
            SimpleFacets.ParsedParams parsed;
            try {
                parsed = this.parseParams("facet.pivot", pivotList);
            }
            catch (SyntaxError e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            List pivotFields = StrUtils.splitSmart((String)parsed.facetValue, (String)",", (boolean)true);
            if (pivotFields.size() < 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Pivot Facet needs at least one field name: " + pivotList);
            }
            SolrIndexSearcher searcher = this.rb.req.getSearcher();
            for (String fieldName : pivotFields) {
                SchemaField sfield = searcher.getSchema().getField(fieldName);
                if (sfield != null) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "\"" + fieldName + "\" is not a valid field name in pivot: " + pivotList);
            }
            String refineKey = null;
            List<StatsField> statsFields = Collections.emptyList();
            List<FacetComponent.FacetBase> facetQueries = Collections.emptyList();
            List<RangeFacetRequest> facetRanges = Collections.emptyList();
            if (null != parsed.localParams) {
                refineKey = parsed.localParams.get("fpt");
                String statsLocalParam = parsed.localParams.get("stats");
                if (null != refineKey && null != statsLocalParam && null == statsInfo) {
                    statsInfo = new StatsInfo(this.rb);
                }
                statsFields = PivotFacetProcessor.getTaggedStatsFields(statsInfo, statsLocalParam);
                try {
                    FacetComponent.FacetContext facetContext = FacetComponent.FacetContext.getFacetContext(this.req);
                    String taggedQueries = parsed.localParams.get(QUERY);
                    if (StringUtils.isEmpty((String)taggedQueries)) {
                        facetQueries = Collections.emptyList();
                    } else {
                        List localParamValue = StrUtils.splitSmart((String)taggedQueries, (char)',');
                        if (localParamValue.size() > 1) {
                            String msg = "query local param of facet.pivotmay not include tags separated by a comma - please use a common tag on all facet.query params you wish to compute under this pivot";
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                        }
                        taggedQueries = (String)localParamValue.get(0);
                        facetQueries = facetContext.getQueryFacetsForTag(taggedQueries);
                    }
                    String taggedRanges = parsed.localParams.get(RANGE);
                    if (StringUtils.isEmpty((String)taggedRanges)) {
                        facetRanges = Collections.emptyList();
                    } else {
                        List localParamValue = StrUtils.splitSmart((String)taggedRanges, (char)',');
                        if (localParamValue.size() > 1) {
                            String msg = "range local param of facet.pivotmay not include tags separated by a comma - please use a common tag on all facet.range params you wish to compute under this pivot";
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                        }
                        taggedRanges = (String)localParamValue.get(0);
                        facetRanges = facetContext.getRangeFacetRequestsForTag(taggedRanges);
                    }
                }
                catch (IllegalStateException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Faceting context not set, cannot calculate pivot values");
                }
            }
            if (null != refineKey) {
                String[] refinementValuesByField;
                for (String refinements : refinementValuesByField = this.params.getParams("fpt" + refineKey)) {
                    pivotResponse.addAll(this.processSingle(pivotFields, refinements, statsFields, parsed, facetQueries, facetRanges));
                }
                continue;
            }
            pivotResponse.addAll(this.processSingle(pivotFields, null, statsFields, parsed, facetQueries, facetRanges));
        }
        return pivotResponse;
    }

    private SimpleOrderedMap<List<NamedList<Object>>> processSingle(List<String> pivotFields, String refinements, List<StatsField> statsFields, SimpleFacets.ParsedParams parsed, List<FacetComponent.FacetBase> facetQueries, List<RangeFacetRequest> facetRanges) throws IOException {
        NamedList facetCounts;
        SolrIndexSearcher searcher = this.rb.req.getSearcher();
        SimpleOrderedMap pivotResponse = new SimpleOrderedMap();
        String field = pivotFields.get(0);
        SchemaField sfield = searcher.getSchema().getField(field);
        LinkedList<String> fnames = new LinkedList<String>();
        for (int i = pivotFields.size() - 1; i > 1; --i) {
            fnames.push(pivotFields.get(i));
        }
        LinkedList<String> vnames = new LinkedList<String>();
        if (null != refinements) {
            List<String> refinementValuesByField = PivotFacetHelper.decodeRefinementValuePath(refinements);
            for (int i = refinementValuesByField.size() - 1; i > 0; --i) {
                vnames.push(refinementValuesByField.get(i));
            }
            String firstFieldsValues = refinementValuesByField.get(0);
            facetCounts = new NamedList();
            facetCounts.add(firstFieldsValues, (Object)this.getSubsetSize(parsed.docs, sfield, firstFieldsValues));
        } else {
            facetCounts = this.getTermCountsForPivots(field, parsed);
        }
        if (pivotFields.size() > 1) {
            String subField = pivotFields.get(1);
            pivotResponse.add(parsed.key, this.doPivots((NamedList<Integer>)facetCounts, field, subField, fnames, vnames, parsed, statsFields, facetQueries, facetRanges));
        } else {
            pivotResponse.add(parsed.key, this.doPivots((NamedList<Integer>)facetCounts, field, null, fnames, vnames, parsed, statsFields, facetQueries, facetRanges));
        }
        return pivotResponse;
    }

    private static List<StatsField> getTaggedStatsFields(StatsInfo statsInfo, String statsLocalParam) {
        if (null == statsLocalParam || null == statsInfo) {
            return Collections.emptyList();
        }
        ArrayList<StatsField> fields = new ArrayList<StatsField>(7);
        List statsAr = StrUtils.splitSmart((String)statsLocalParam, (char)',');
        if (1 < statsAr.size()) {
            String msg = "stats local param of facet.pivotmay not include tags separated by a comma - please use a common tag on all stats.field params you wish to compute under this pivot";
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        for (String stat : statsAr) {
            fields.addAll(statsInfo.getStatsFieldsByTag(stat));
        }
        return fields;
    }

    protected List<NamedList<Object>> doPivots(NamedList<Integer> superFacets, String field, String subField, Deque<String> fnames, Deque<String> vnames, SimpleFacets.ParsedParams parsed, List<StatsField> statsFields, List<FacetComponent.FacetBase> facetQueries, List<RangeFacetRequest> facetRanges) throws IOException {
        boolean isShard = this.rb.req.getParams().getBool("isShard", false);
        SolrIndexSearcher searcher = this.rb.req.getSearcher();
        SchemaField sfield = searcher.getSchema().getField(field);
        FieldType ftype = sfield.getType();
        String nextField = fnames.poll();
        BytesRefBuilder termval = new BytesRefBuilder();
        ArrayList<NamedList<Object>> values = new ArrayList<NamedList<Object>>(superFacets.size());
        for (Map.Entry kv : superFacets) {
            if ((Integer)kv.getValue() < this.getMinCountForField(field)) continue;
            String fieldValue = (String)kv.getKey();
            int pivotCount = (Integer)kv.getValue();
            SimpleOrderedMap pivot = new SimpleOrderedMap();
            pivot.add("field", (Object)field);
            if (null == fieldValue) {
                pivot.add("value", null);
            } else {
                ftype.readableToIndexed(fieldValue, termval);
                pivot.add("value", ftype.toObject(sfield, termval.get()));
            }
            pivot.add("count", (Object)pivotCount);
            DocSet subset = this.getSubset(parsed.docs, sfield, fieldValue);
            this.addPivotQueriesAndRanges((NamedList<Object>)pivot, this.params, subset, facetQueries, facetRanges);
            if (subField != null) {
                NamedList facetCounts;
                if (!vnames.isEmpty()) {
                    String val = vnames.pop();
                    facetCounts = new NamedList();
                    facetCounts.add(val, (Object)this.getSubsetSize(subset, searcher.getSchema().getField(subField), val));
                } else {
                    facetCounts = this.getTermCountsForPivots(subField, parsed.withDocs(subset));
                }
                if (facetCounts.size() >= 1) {
                    pivot.add("pivot", this.doPivots((NamedList<Integer>)facetCounts, subField, nextField, fnames, vnames, parsed.withDocs(subset), statsFields, facetQueries, facetRanges));
                }
            }
            if ((isShard || 0 < pivotCount) && !statsFields.isEmpty()) {
                LinkedHashMap<String, StatsValues> stv = new LinkedHashMap<String, StatsValues>();
                for (StatsField statsField : statsFields) {
                    stv.put(statsField.getOutputKey(), statsField.computeLocalStatsValues(subset));
                }
                pivot.add("stats", StatsComponent.convertToResponse(stv));
            }
            values.add((NamedList<Object>)pivot);
        }
        fnames.push(nextField);
        return values;
    }

    private int getSubsetSize(DocSet base, SchemaField field, String pivotValue) throws IOException {
        FieldType ft = field.getType();
        if (null == pivotValue) {
            Query query = ft.getRangeQuery(null, field, null, null, false, false);
            DocSet hasVal = this.searcher.getDocSet(query);
            return base.andNotSize(hasVal);
        }
        Query query = ft.getFieldTermQuery(null, field, pivotValue);
        return this.searcher.numDocs(query, base);
    }

    private DocSet getSubset(DocSet base, SchemaField field, String pivotValue) throws IOException {
        FieldType ft = field.getType();
        if (null == pivotValue) {
            Query query = ft.getRangeQuery(null, field, null, null, false, false);
            DocSet hasVal = this.searcher.getDocSet(query);
            return base.andNot(hasVal);
        }
        Query query = ft.getFieldTermQuery(null, field, pivotValue);
        return this.searcher.getDocSet(query, base);
    }

    protected void addPivotQueriesAndRanges(NamedList<Object> pivot, SolrParams params, DocSet docs, List<FacetComponent.FacetBase> facetQueries, List<RangeFacetRequest> facetRanges) throws IOException {
        assert (null != facetQueries);
        assert (null != facetRanges);
        if (!facetQueries.isEmpty()) {
            SimpleFacets facets = new SimpleFacets(this.req, docs, params);
            SimpleOrderedMap res = new SimpleOrderedMap();
            for (FacetComponent.FacetBase facetQuery : facetQueries) {
                try {
                    SimpleFacets.ParsedParams parsed = this.getParsedParams(params, docs, facetQuery);
                    facets.getFacetQueryCount(parsed, (NamedList<Integer>)res);
                }
                catch (SyntaxError e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid facet.query (" + facetQuery.facetStr + ") cause: " + e.getMessage(), (Throwable)e);
                }
            }
            pivot.add(PivotListEntry.QUERIES.getName(), (Object)res);
        }
        if (!facetRanges.isEmpty()) {
            RangeFacetProcessor rangeFacetProcessor = new RangeFacetProcessor(this.req, docs, params, null);
            SimpleOrderedMap resOuter = new SimpleOrderedMap();
            for (RangeFacetRequest rangeFacet : facetRanges) {
                try {
                    rangeFacetProcessor.getFacetRangeCounts(rangeFacet, (NamedList<Object>)resOuter);
                }
                catch (SyntaxError e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid facet.range (" + rangeFacet.facetStr + ") cause: " + e.getMessage(), (Throwable)e);
                }
            }
            pivot.add(PivotListEntry.RANGES.getName(), (Object)resOuter);
        }
    }

    private SimpleFacets.ParsedParams getParsedParams(SolrParams params, DocSet docs, FacetComponent.FacetBase facet) {
        SolrParams wrapped = SolrParams.wrapDefaults((SolrParams)facet.localParams, (SolrParams)this.global);
        RequiredSolrParams required = new RequiredSolrParams(params);
        return new SimpleFacets.ParsedParams(facet.localParams, wrapped, (SolrParams)required, facet.facetOn, docs, facet.getKey(), facet.getTags(), -1);
    }

    private int getMinCountForField(String fieldname) {
        return this.params.getFieldInt(fieldname, "facet.pivot.mincount", 1);
    }
}

