/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.tools;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.mp4parser.tools.MemoryUtils;
import org.mp4parser.tools.Utf8;

public final class IsoTypeReader {
    private static final long MAX_RECORD_LENGTH = 1000000L;

    public static long readUInt32BE(ByteBuffer bb) {
        long ch1 = IsoTypeReader.readUInt8(bb);
        long ch2 = IsoTypeReader.readUInt8(bb);
        long ch3 = IsoTypeReader.readUInt8(bb);
        long ch4 = IsoTypeReader.readUInt8(bb);
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public static long readUInt32(ByteBuffer bb) {
        long i = bb.getInt();
        if (i < 0L) {
            i += 0x100000000L;
        }
        return i;
    }

    public static int readUInt24(ByteBuffer bb) {
        int result = 0;
        result += IsoTypeReader.readUInt16(bb) << 8;
        return result += IsoTypeReader.byte2int(bb.get());
    }

    public static int readUInt16(ByteBuffer bb) {
        int result = 0;
        result += IsoTypeReader.byte2int(bb.get()) << 8;
        return result += IsoTypeReader.byte2int(bb.get());
    }

    public static int readUInt16BE(ByteBuffer bb) {
        int result = 0;
        result += IsoTypeReader.byte2int(bb.get());
        return result += IsoTypeReader.byte2int(bb.get()) << 8;
    }

    public static int readUInt8(ByteBuffer bb) {
        return IsoTypeReader.byte2int(bb.get());
    }

    public static int byte2int(byte b) {
        return b < 0 ? b + 256 : b;
    }

    public static String readString(ByteBuffer byteBuffer) {
        byte read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = byteBuffer.get()) != 0) {
            out.write(read);
        }
        return Utf8.convert(out.toByteArray());
    }

    public static String readString(ByteBuffer byteBuffer, int length) {
        byte[] buffer = MemoryUtils.allocateByteArray(length, 1000000L);
        byteBuffer.get(buffer);
        return Utf8.convert(buffer);
    }

    public static long readUInt64(ByteBuffer byteBuffer) {
        long result = 0L;
        if ((result += IsoTypeReader.readUInt32(byteBuffer) << 32) < 0L) {
            throw new RuntimeException("I don't know how to deal with UInt64! long is not sufficient and I don't want to use BigInt");
        }
        return result += IsoTypeReader.readUInt32(byteBuffer);
    }

    public static double readFixedPoint1616(ByteBuffer bb) {
        byte[] bytes = new byte[4];
        bb.get(bytes);
        int result = 0;
        result |= bytes[0] << 24 & 0xFF000000;
        result |= bytes[1] << 16 & 0xFF0000;
        result |= bytes[2] << 8 & 0xFF00;
        return (double)(result |= bytes[3] & 0xFF) / 65536.0;
    }

    public static double readFixedPoint0230(ByteBuffer bb) {
        byte[] bytes = new byte[4];
        bb.get(bytes);
        int result = 0;
        result |= bytes[0] << 24 & 0xFF000000;
        result |= bytes[1] << 16 & 0xFF0000;
        result |= bytes[2] << 8 & 0xFF00;
        return (double)(result |= bytes[3] & 0xFF) / 1.073741824E9;
    }

    public static float readFixedPoint88(ByteBuffer bb) {
        byte[] bytes = new byte[2];
        bb.get(bytes);
        int result = 0;
        result = (short)(result | bytes[0] << 8 & 0xFF00);
        result = (short)(result | bytes[1] & 0xFF);
        return (float)result / 256.0f;
    }

    public static String readIso639(ByteBuffer bb) {
        int bits = IsoTypeReader.readUInt16(bb);
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < 3) {
            int c = bits >> (2 - i) * 5 & 0x1F;
            result.append((char)(c + 96));
            ++i;
        }
        return result.toString();
    }

    public static String read4cc(ByteBuffer bb) {
        byte[] codeBytes = new byte[4];
        bb.get(codeBytes);
        try {
            return new String(codeBytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static long readUInt48(ByteBuffer byteBuffer) {
        long result = (long)IsoTypeReader.readUInt16(byteBuffer) << 32;
        if (result < 0L) {
            throw new RuntimeException("I don't know how to deal with UInt64! long is not sufficient and I don't want to use BigInt");
        }
        return result += IsoTypeReader.readUInt32(byteBuffer);
    }
}

