/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.AbstractCell;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.LazilyCompactedRow;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.big.BigTableReader;
import org.apache.cassandra.io.sstable.format.big.BigTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.FileDataInput;

public class BigFormat
implements SSTableFormat {
    public static final BigFormat instance = new BigFormat();
    public static final BigVersion latestVersion = new BigVersion("lb");
    private static final SSTableReader.Factory readerFactory = new ReaderFactory();
    private static final SSTableWriter.Factory writerFactory = new WriterFactory();

    private BigFormat() {
    }

    @Override
    public Version getLatestVersion() {
        return latestVersion;
    }

    @Override
    public Version getVersion(String version) {
        return new BigVersion(version);
    }

    @Override
    public SSTableWriter.Factory getWriterFactory() {
        return writerFactory;
    }

    @Override
    public SSTableReader.Factory getReaderFactory() {
        return readerFactory;
    }

    @Override
    public Iterator<OnDiskAtom> getOnDiskIterator(FileDataInput in, ColumnSerializer.Flag flag, int expireBefore, CFMetaData cfm, Version version) {
        return AbstractCell.onDiskIterator(in, flag, expireBefore, version, cfm.comparator);
    }

    @Override
    public AbstractCompactedRow getCompactedRowWriter(CompactionController controller, ImmutableList<OnDiskAtomIterator> onDiskAtomIterators) {
        return new LazilyCompactedRow(controller, (List<? extends OnDiskAtomIterator>)onDiskAtomIterators);
    }

    public RowIndexEntry.IndexSerializer getIndexSerializer(CFMetaData cfMetaData) {
        return new RowIndexEntry.Serializer(new IndexHelper.IndexInfo.Serializer(cfMetaData.comparator));
    }

    static class BigVersion
    extends Version {
        public static final String current_version = "lb";
        public static final String earliest_supported_version = "jb";
        private final boolean isLatestVersion;
        private final boolean hasSamplingLevel;
        private final boolean newStatsFile;
        private final boolean hasAllAdlerChecksums;
        private final boolean hasRepairedAt;
        private final boolean tracksLegacyCounterShards;
        private final boolean newFileName;
        private final boolean hasCommitLogLowerBound;

        public BigVersion(String version) {
            super(instance, version);
            this.isLatestVersion = version.compareTo(current_version) == 0;
            this.hasSamplingLevel = version.compareTo("ka") >= 0;
            this.newStatsFile = version.compareTo("ka") >= 0;
            this.hasAllAdlerChecksums = version.compareTo("ka") >= 0;
            this.hasRepairedAt = version.compareTo("ka") >= 0;
            this.tracksLegacyCounterShards = version.compareTo("ka") >= 0;
            this.newFileName = version.compareTo("la") >= 0;
            this.hasCommitLogLowerBound = version.compareTo(current_version) >= 0;
        }

        @Override
        public boolean isLatestVersion() {
            return this.isLatestVersion;
        }

        @Override
        public boolean hasSamplingLevel() {
            return this.hasSamplingLevel;
        }

        @Override
        public boolean hasNewStatsFile() {
            return this.newStatsFile;
        }

        @Override
        public boolean hasAllAdlerChecksums() {
            return this.hasAllAdlerChecksums;
        }

        @Override
        public boolean hasRepairedAt() {
            return this.hasRepairedAt;
        }

        @Override
        public boolean tracksLegacyCounterShards() {
            return this.tracksLegacyCounterShards;
        }

        @Override
        public boolean hasNewFileName() {
            return this.newFileName;
        }

        @Override
        public boolean hasCommitLogLowerBound() {
            return this.hasCommitLogLowerBound;
        }

        @Override
        public boolean isCompatible() {
            return this.version.compareTo(earliest_supported_version) >= 0 && this.version.charAt(0) <= current_version.charAt(0);
        }
    }

    static class ReaderFactory
    extends SSTableReader.Factory {
        ReaderFactory() {
        }

        @Override
        public SSTableReader open(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, Long maxDataAge, StatsMetadata sstableMetadata, SSTableReader.OpenReason openReason) {
            return new BigTableReader(descriptor, components, metadata, partitioner, maxDataAge, sstableMetadata, openReason);
        }
    }

    static class WriterFactory
    extends SSTableWriter.Factory {
        WriterFactory() {
        }

        @Override
        public SSTableWriter open(Descriptor descriptor, long keyCount, long repairedAt, CFMetaData metadata, IPartitioner partitioner, MetadataCollector metadataCollector) {
            return new BigTableWriter(descriptor, (Long)keyCount, (Long)repairedAt, metadata, partitioner, metadataCollector);
        }
    }
}

