/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.calculator.content;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.loomchild.maligna.calculator.Calculator;
import net.loomchild.maligna.coretypes.Alignment;

public class OracleCalculator
implements Calculator {
    public static final float DEFAULT_FAILURE_SCORE = Float.POSITIVE_INFINITY;
    public static final float DEFAULT_SUCCESS_SCORE = 0.0f;
    private Set<Alignment> alignmentSet;
    private float successScore;
    private float failureScore;

    public OracleCalculator(Collection<Alignment> alignmentCollection, float failureScore, float successScore) {
        this.alignmentSet = new HashSet<Alignment>(alignmentCollection);
        this.failureScore = failureScore;
        this.successScore = successScore;
    }

    public OracleCalculator(Collection<Alignment> alignmentCollection, float failureScore) {
        this(alignmentCollection, failureScore, 0.0f);
    }

    public OracleCalculator(Collection<Alignment> alignmentCollection) {
        this(alignmentCollection, Float.POSITIVE_INFINITY, 0.0f);
    }

    @Override
    public float calculateScore(List<String> sourceSegmentList, List<String> targetSegmentList) {
        Alignment alignment = new Alignment(sourceSegmentList, targetSegmentList);
        if (this.alignmentSet.contains(alignment)) {
            return this.successScore;
        }
        return this.failureScore;
    }
}

