/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JLabel;

public final class Mnemonics {
    private static final Pattern RE_MNEMONIC_END = Pattern.compile("\\s*\\(&[A-Za-z0-9]\\)(?=[.\\uFF1A]*$)");
    private static final Pattern RE_MNEMONIC_INSIDE = Pattern.compile("&(\\p{L})");

    private Mnemonics() {
    }

    public static String removeMnemonics(String text) {
        text = RE_MNEMONIC_END.matcher(text).replaceFirst("");
        text = RE_MNEMONIC_INSIDE.matcher(text).replaceFirst("$1");
        return text;
    }

    public static void setLocalizedText(AbstractButton item, String text) {
        Mnemonics.setLocalizedText(item, text, null);
    }

    static void setLocalizedText(AbstractButton item, String text, Locale locale) {
        Mnemonics.setLocalizedText2(item, text, locale);
    }

    public static void setLocalizedText(JLabel item, String text) {
        Mnemonics.setLocalizedText(item, text, null);
    }

    static void setLocalizedText(JLabel item, String text, Locale locale) {
        Mnemonics.setLocalizedText2(item, text, locale);
    }

    private static void setLocalizedText2(Object item, String text, Locale locale) {
        int i;
        if (text == null) {
            Mnemonics.setText(item, null);
            return;
        }
        if (Mnemonics.isMacOS()) {
            text = RE_MNEMONIC_END.matcher(text).replaceFirst("");
        }
        if ((i = Mnemonics.findMnemonicAmpersand(text)) < 0) {
            Mnemonics.setText(item, text);
            Mnemonics.setMnemonic(item, 0);
        } else {
            Mnemonics.setText(item, text.substring(0, i) + text.substring(i + 1));
            Mnemonics.setMnemonicAndIndex(item, text.charAt(i + 1), i, locale);
        }
    }

    public static int findMnemonicAmpersand(String text) {
        int i = -1;
        do {
            if ((i = text.indexOf(38, i + 1)) < 0 || i + 1 >= text.length() || text.charAt(i + 1) == ' ' || text.charAt(i + 1) == '\'' && i > 0 && text.charAt(i - 1) == '\'') continue;
            return i;
        } while (i >= 0);
        return -1;
    }

    private static void setMnemonicAndIndex(Object item, char ch, int index, Locale locale) {
        if (Mnemonics.isMacOS()) {
            Mnemonics.setMnemonic(item, 0);
        } else if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') {
            Mnemonics.setMnemonic(item, ch);
            Mnemonics.setMnemonicIndex(item, index);
        } else {
            int latinCode = Mnemonics.getLatinKeycode(ch, locale);
            Mnemonics.setMnemonic(item, latinCode);
            if (latinCode != 0) {
                Mnemonics.setMnemonicIndex(item, index);
            }
        }
    }

    private static int getLatinKeycode(char localeChar, Locale locale) {
        try {
            String str = Mnemonics.getBundle(locale).getString("MNEMONIC_" + localeChar);
            if (str.length() == 1) {
                return str.charAt(0);
            }
            return Integer.parseInt(str);
        }
        catch (MissingResourceException x) {
            return 0;
        }
    }

    private static void setMnemonicIndex(Object item, int index) {
        if (item instanceof AbstractButton) {
            ((AbstractButton)item).setDisplayedMnemonicIndex(index);
        } else if (item instanceof JLabel) {
            ((JLabel)item).setDisplayedMnemonicIndex(index);
        }
    }

    private static void setText(Object item, String text) {
        if (item instanceof AbstractButton) {
            ((AbstractButton)item).setText(text);
        } else {
            ((JLabel)item).setText(text);
        }
    }

    private static void setMnemonic(Object item, int mnem) {
        if (mnem >= 97 && mnem <= 122) {
            mnem += -32;
        }
        if (item instanceof AbstractButton) {
            ((AbstractButton)item).setMnemonic(mnem);
        } else {
            ((JLabel)item).setDisplayedMnemonic(mnem);
        }
    }

    private static ResourceBundle getBundle(Locale locale) {
        if (locale == null) {
            return ResourceBundle.getBundle("org.openide.awt.Mnemonics");
        }
        return ResourceBundle.getBundle("org.openide.awt.Mnemonics", locale);
    }

    static boolean isMacOS() {
        return System.getProperty("os.name").contains("OS X");
    }
}

