/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.IUDTInfo;

public class UDTTypeExpander
implements INodeExpander {
    @Override
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        ISQLConnection conn = session.getSQLConnection();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSchemaName();
        ObjFilterMatcher filterMatcher = new ObjFilterMatcher(session.getProperties());
        IUDTInfo[] udts = conn.getSQLMetaData().getUDTs(catalogName, schemaName, filterMatcher.getSqlLikeMatchString(), null);
        for (int i = 0; i < udts.length; ++i) {
            if (!filterMatcher.matches(udts[i].getSimpleName())) continue;
            ObjectTreeNode child = new ObjectTreeNode(session, udts[i]);
            childNodes.add(child);
        }
        return childNodes;
    }
}

