/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.base.SqlElementFactory;
import com.intellij.sql.formatter.SqlSpacing;
import com.intellij.sql.psi.SqlCodeFragmentImpl;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.parser.SqlParserDefinition;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlParserDefinitionBase
extends SqlParserDefinition {
    private static final IFileElementType SQL_FILE = new SqlFileElementType("SQL_FILE", (Language)SqlLanguage.INSTANCE);
    private final IFileElementType myFileElementType;
    private volatile SqlElementFactory myElementFactory;

    protected SqlParserDefinitionBase(@NotNull IFileElementType fileElementType) {
        if (fileElementType == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(0);
        }
        this.myFileElementType = fileElementType;
    }

    public SqlParserDefinitionBase() {
        this(SQL_FILE);
    }

    protected SqlElementFactory createElementFactory() {
        if (this.myFileElementType != SQL_FILE) {
            throw new UnsupportedOperationException("Override createElementFactory in " + ((Object)((Object)this)).getClass());
        }
        return new SqlElementFactory(){

            @Override
            public PsiElement createCompositeElement(ASTNode node) {
                return SqlParserDefinitionBase.createCompositeElementImpl(node);
            }
        };
    }

    @NotNull
    public final SqlElementFactory getElementFactory() {
        SqlElementFactory factory = this.myElementFactory;
        if (factory == null) {
            this.myElementFactory = factory = this.createElementFactory();
        }
        SqlElementFactory sqlElementFactory = factory;
        if (sqlElementFactory == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(1);
        }
        return sqlElementFactory;
    }

    @NotNull
    public Lexer createLexer(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    public final IFileElementType getFileNodeType() {
        return this.myFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = SqlTokens.WS_TOKENS;
        if (tokenSet == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = SqlTokens.COMMENT_TOKENS;
        if (tokenSet == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = SqlTokens.STRING_TOKENS;
        if (tokenSet == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)viewProvider.getManager().getProject()).getInjectionHost(viewProvider);
        IElementType type = (IElementType)InjectedLanguageUtil.INJECTED_FRAGMENT_TYPE.get((UserDataHolder)injectionHost);
        if (type != null) {
            SqlCodeFragmentImpl fragment = new SqlCodeFragmentImpl(viewProvider, (SqlLanguageDialect)this.getFileNodeType().getLanguage(), type, null);
            fragment.setContext((PsiElement)injectionHost);
            return fragment;
        }
        return new SqlFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (left == null || right == null) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        IElementType leftType = left.getElementType();
        if (SqlTokens.LINE_COMMENT_TOKENS.contains(leftType) || leftType == SqlTokens.ORAP_SLASH_DELIMITER_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        boolean must = SqlSpacing.languageRequiresSpaceBetween(left, right);
        return must ? ParserDefinition.SpaceRequirements.MUST : ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public final PsiElement createElement(ASTNode node) {
        PsiElement psiElement = this.getElementFactory().createCompositeElement(node);
        if (psiElement == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @Override
    public final <T extends PsiElement> T createElement(StubElement<T> stub) {
        return this.getElementFactory().createCompositeElement(stub);
    }

    @Nullable
    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text2) {
        return null;
    }

    @Nullable
    public CompositeElement createComposite(IElementType type) {
        return this.getElementFactory().createElementNode(type);
    }

    @Nullable
    public LeafElement createLeaf(@NotNull IElementType type, @NotNull CharSequence text2) {
        if (type == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(7);
        }
        return null;
    }

    @NotNull
    private static PsiElement createCompositeElementImpl(ASTNode node) {
        ASTNode fileElement = node;
        while (fileElement.getTreeParent() != null) {
            fileElement = fileElement.getTreeParent();
        }
        Object object = fileElement = fileElement instanceof TreeElement ? TreeUtil.getFileElement((TreeElement)((TreeElement)node)) : fileElement;
        if (!(fileElement instanceof FileASTNode)) {
            ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
            if (aSTWrapperPsiElement == null) {
                SqlParserDefinitionBase.$$$reportNull$$$0(8);
            }
            return aSTWrapperPsiElement;
        }
        Language fileLanguage = SqlParserDefinitionBase.getLanguage(fileElement);
        Object dialect = fileLanguage instanceof SqlLanguageDialect ? fileLanguage : SqlDialectMappings.getDefaultSqlDialect();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(dialect);
        if (parserDefinition == null) {
            SqlDialectImplUtil.LOG.error("required parser definition not found for: " + dialect.getDisplayName() + ", nodeType: " + node.getElementType() + ", fileType: " + fileElement.getElementType());
            ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
            if (aSTWrapperPsiElement == null) {
                SqlParserDefinitionBase.$$$reportNull$$$0(9);
            }
            return aSTWrapperPsiElement;
        }
        PsiElement psiElement = parserDefinition.createElement(node);
        if (psiElement == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @NotNull
    private static Language getLanguage(@NotNull ASTNode e) {
        PsiElement psi;
        if (e == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(11);
        }
        if ((psi = e.getPsi()) instanceof DummyHolder) {
            Language language = psi.getLanguage();
            if (language == null) {
                SqlParserDefinitionBase.$$$reportNull$$$0(12);
            }
            return language;
        }
        FileViewProvider provider = psi.getContainingFile().getViewProvider();
        if (provider instanceof TemplateLanguageFileViewProvider) {
            Language language = ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage();
            if (language == null) {
                SqlParserDefinitionBase.$$$reportNull$$$0(13);
            }
            return language;
        }
        Language language = e.getElementType().getLanguage();
        if (language == null) {
            SqlParserDefinitionBase.$$$reportNull$$$0(14);
        }
        return language;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/base/SqlParserDefinitionBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/base/SqlParserDefinitionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeElementImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLeaf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

