/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.epp.ide.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.puppet.epp.EppFileType;
import com.intellij.lang.puppet.epp.elementTypes.EppElementTypes;
import com.intellij.lang.puppet.epp.ide.editor.EppSmartKeysUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class EppTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            EppTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EppTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            EppTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            EppTypedHandler.$$$reportNull$$$0(3);
        }
        if (file.getVirtualFile().getFileType() != EppFileType.INSTANCE) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                EppTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        Document document = editor.getDocument();
        CharSequence charSequence = document.getCharsSequence();
        if (c == '%' && EppSmartKeysUtil.charIs(charSequence, offset - 1, '<') && EppSmartKeysUtil.getTokenInfo((Editor)editor, (int)(offset - 1)).tokenType == EppElementTypes.EPP_TEMPLATE_BLOCK) {
            EppSmartKeysUtil.TokenInfo nextEppTokenInfo = EppSmartKeysUtil.getNextEppTokenInfo(editor, offset);
            if (nextEppTokenInfo.tokenType == EppElementTypes.EPP_EXPRESSION_CLOSER) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    EppTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
            document.insertString(offset, (CharSequence)"%  %>");
            caretModel.moveToOffset(offset + 2);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                EppTypedHandler.$$$reportNull$$$0(6);
            }
            return result;
        }
        if (c == '|' && EppSmartKeysUtil.charIs(charSequence, offset - 1, ' ')) {
            EppSmartKeysUtil.TokenInfo openerInfo = EppSmartKeysUtil.getTokenInfo(editor, offset - 2);
            if (openerInfo.tokenType == EppElementTypes.EPP_EXPRESSION_OPENER && (openerInfo.startOffset == 0 || EppSmartKeysUtil.getPrevEppTokenInfo(editor, openerInfo.startOffset - 1).isEmpty())) {
                EppSmartKeysUtil.TokenInfo nextEppTokenInfo = EppSmartKeysUtil.getNextEppTokenInfo(editor, offset);
                if (nextEppTokenInfo.tokenType == EppElementTypes.EPP_EXPRESSION_CLOSER) {
                    if (EppSmartKeysUtil.textIs(charSequence, nextEppTokenInfo.startOffset - 2, "| ")) {
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                        if (result == null) {
                            EppTypedHandler.$$$reportNull$$$0(7);
                        }
                        return result;
                    }
                    document.insertString(nextEppTokenInfo.startOffset, (CharSequence)"| ");
                    document.insertString(offset, (CharSequence)"| ");
                    caretModel.moveToOffset(offset + 2);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        EppTypedHandler.$$$reportNull$$$0(8);
                    }
                    return result;
                }
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            EppTypedHandler.$$$reportNull$$$0(9);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/epp/ide/editor/EppTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/epp/ide/editor/EppTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

