/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;

public enum BraceStyle {
    EndOfLine(1),
    NextLine(2),
    NextLineShifted(3),
    NextLineEachShifted(4),
    NextLineIfWrapped(5);

    private final int value;

    private BraceStyle(int value) {
        this.value = value;
    }

    @CommonCodeStyleSettings.BraceStyleConstant
    public final int intValue() {
        return this.value;
    }

    public static BraceStyle fromInt(int value) {
        for (BraceStyle style : BraceStyle.values()) {
            if (style.intValue() != value) continue;
            return style;
        }
        throw new InvalidDataException("Unknown brace style integer value " + value);
    }
}

