/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter;

import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.spi.JsonProvider;
import java.util.List;
import java.util.Map;

public class HasFieldFilter
extends PathTokenFilter {
    public HasFieldFilter(String condition) {
        super(condition);
    }

    @Override
    public Object filter(Object obj, JsonProvider jsonProvider) {
        List<Object> src = jsonProvider.toList(obj);
        List<Object> result = jsonProvider.createList();
        String trimmedCondition = this.condition;
        if (this.condition.contains("['")) {
            trimmedCondition = trimmedCondition.replace("['", ".");
            trimmedCondition = trimmedCondition.replace("']", "");
        }
        trimmedCondition = this.trim(trimmedCondition, 5, 2);
        for (Object item : src) {
            Map<String, Object> map;
            if (!jsonProvider.isMap(item) || !(map = jsonProvider.toMap(item)).containsKey(trimmedCondition)) continue;
            result.add(map);
        }
        return result;
    }

    @Override
    public Object getRef(Object obj, JsonProvider jsonProvider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isArrayFilter() {
        return true;
    }
}

