/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.runAnywhere;

import com.intellij.ide.actions.runAnything.activity.RunAnythingAnActionProvider;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskRunAction;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsbtRunAnythingProvider
extends RunAnythingAnActionProvider<JsbtTaskRunAction> {
    private static final AtomicBoolean DONE = new AtomicBoolean(false);

    protected JsbtRunAnythingProvider() {
        JsbtRunAnythingProvider.disableRunAnythingInWebStorm();
    }

    @Nullable
    public JsbtTaskRunAction findMatchingValue(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(1);
        }
        return this.getValues(dataContext, pattern).stream().filter(value -> {
            if (pattern == null) {
                JsbtRunAnythingProvider.$$$reportNull$$$0(16);
            }
            return this.getCommand((JsbtTaskRunAction)((Object)value)).startsWith(pattern);
        }).findFirst().orElse(null);
    }

    @NotNull
    public Collection<JsbtTaskRunAction> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        Project project;
        if (dataContext == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(3);
        }
        if ((project = JsbtRunAnythingProvider.getProject(dataContext)) == null) {
            List<JsbtTaskRunAction> list = Collections.emptyList();
            if (list == null) {
                JsbtRunAnythingProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (!pattern.startsWith(this.getCommandPrefix(project))) {
            List<JsbtTaskRunAction> list = Collections.emptyList();
            if (list == null) {
                JsbtRunAnythingProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<JsbtFileStructure> structures = this.getFileStructures(project);
        ArrayList<JsbtTaskRunAction> actions = new ArrayList<JsbtTaskRunAction>();
        for (JsbtFileStructure structure : structures) {
            for (String taskName : structure.getTaskNames()) {
                actions.add(this.createAction(project, structure, taskName));
            }
        }
        ArrayList<JsbtTaskRunAction> arrayList = actions;
        if (arrayList == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public abstract String getCommand(@NotNull JsbtTaskRunAction var1);

    @NotNull
    protected abstract JsbtService getService();

    @NotNull
    protected abstract String getCommandPrefix(@NotNull Project var1);

    @Nullable
    protected JsbtFileStructure getBuildfileStructure(@NotNull Project project, @NotNull VirtualFile buildfile) {
        if (project == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(7);
        }
        if (buildfile == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(8);
        }
        return this.getService().getFileManager(project).getCachedStructure(buildfile);
    }

    @NotNull
    private JsbtTaskRunAction createAction(@NotNull Project project, @NotNull JsbtFileStructure structure, @NotNull String taskName) {
        if (project == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(9);
        }
        if (structure == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(10);
        }
        if (taskName == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(11);
        }
        JsbtTaskSet task = new JsbtTaskSet(structure, Collections.singletonList(taskName));
        JsbtTaskRunAction action = new JsbtTaskRunAction(project, this.getService(), task);
        action.setIcon(this.getIcon((AnAction)action));
        JsbtTaskRunAction jsbtTaskRunAction = action;
        if (jsbtTaskRunAction == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(12);
        }
        return jsbtTaskRunAction;
    }

    @Nullable
    public abstract String getCompletionGroupTitle();

    @NotNull
    private List<JsbtFileStructure> getFileStructures(@NotNull Project project) {
        if (project == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(13);
        }
        JsbtFileManager fileManager = this.getService().getFileManager(project);
        ArrayList<JsbtFileStructure> result2 = new ArrayList<JsbtFileStructure>();
        for (VirtualFile buildfile : fileManager.getBuildfiles()) {
            result2.add(this.getBuildfileStructure(project, buildfile));
        }
        ArrayList<JsbtFileStructure> arrayList = result2;
        if (arrayList == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    private static Project getProject(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JsbtRunAnythingProvider.$$$reportNull$$$0(15);
        }
        return (Project)CommonDataKeys.PROJECT.getData(dataContext);
    }

    static void disableRunAnythingInWebStorm() {
        if (DONE.compareAndSet(false, true) && PlatformUtils.isWebStorm()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                ActionManager manager = ActionManager.getInstance();
                DefaultActionGroup group = (DefaultActionGroup)ObjectUtils.tryCast((Object)manager.getAction("ToolbarRunGroup"), DefaultActionGroup.class);
                AnAction runAnythingAction = manager.getAction("RunAnything");
                if (group != null && runAnythingAction != null) {
                    group.remove(runAnythingAction);
                }
                manager.unregisterAction("RunAnything");
                ActionToolbarImpl.updateAllToolbarsImmediately();
            }, ModalityState.any());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/runAnywhere/JsbtRunAnythingProvider";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/runAnywhere/JsbtRunAnythingProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStructures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBuildfileStructure";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileStructures";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findMatchingValue$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

