/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.AbstractMissingFilesAction;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RollbackDeletionAction
extends AbstractMissingFilesAction {
    @Override
    protected List<VcsException> processFiles(AbstractVcs vcs, List<FilePath> files2) {
        RollbackEnvironment environment = vcs.getRollbackEnvironment();
        if (environment == null) {
            return Collections.emptyList();
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(vcs.getDisplayName() + ": performing rollback...");
        }
        ArrayList<VcsException> result2 = new ArrayList<VcsException>(0);
        try {
            environment.rollbackMissingFileDeletion(files2, result2, (RollbackProgressListener)new RollbackProgressModifier(files2.size(), indicator));
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)ChangesUtil.filePathsToFiles(files2));
        return result2;
    }

    @Override
    protected String getName() {
        return VcsBundle.message((String)"changes.action.rollback.text", (Object[])new Object[0]);
    }

    @Override
    protected boolean synchronously() {
        return false;
    }
}

