/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorSchemesUsagesCollector
extends ApplicationUsagesCollector {
    public static final String GROUP_ID = "Color Schemes";
    public static final String SCHEME_NAME_OTHER = "Other";
    public static final String[] KNOWN_NAMES = new String[]{"Obsidian", "Visual Studio", "Solarized", "Wombat", "Monkai", "XCode", "Sublime", "Oblivion", "Zenburn", "Cobalt", "Netbeans", "Eclipse", "Aptana", "Flash Builder"};

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        Set<UsageDescriptor> set = EditorColorSchemesUsagesCollector.getDescriptors();
        if (set == null) {
            EditorColorSchemesUsagesCollector.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors() {
        EditorColorsScheme currentScheme = EditorColorsManager.getInstance().getGlobalScheme();
        HashSet usages = ContainerUtil.newHashSet();
        String schemeName = SCHEME_NAME_OTHER;
        if (currentScheme instanceof AbstractColorsScheme) {
            AbstractColorsScheme original;
            String name = currentScheme.getName();
            if (name.startsWith("_@user_") && (original = ((AbstractColorsScheme)currentScheme).getOriginal()) != null) {
                schemeName = original.getName();
            }
            if (schemeName == SCHEME_NAME_OTHER) {
                String knownName = EditorColorSchemesUsagesCollector.getKnownSchemeName(name);
                if (knownName != null) {
                    schemeName = knownName;
                }
                boolean isDark = ColorUtil.isDark((Color)currentScheme.getDefaultBackground());
                schemeName = schemeName + "[" + (isDark ? "Dark" : "Light") + "]";
            }
            usages.add(new UsageDescriptor(schemeName, 1));
        }
        HashSet hashSet = usages;
        if (hashSet == null) {
            EditorColorSchemesUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Nullable
    private static String getKnownSchemeName(@NonNls @NotNull String schemeName) {
        if (schemeName == null) {
            EditorColorSchemesUsagesCollector.$$$reportNull$$$0(2);
        }
        for (String knownName : KNOWN_NAMES) {
            if (!schemeName.toUpperCase().contains(knownName.toUpperCase())) continue;
            return knownName;
        }
        return null;
    }

    @Override
    @NotNull
    public String getGroupId() {
        if ("statistics.ui.editor.color.schemes" == null) {
            EditorColorSchemesUsagesCollector.$$$reportNull$$$0(3);
        }
        return "statistics.ui.editor.color.schemes";
    }

    @Override
    @Nullable
    public FUSUsageContext getContext() {
        return FUSUsageContext.OS_CONTEXT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/ui/EditorColorSchemesUsagesCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/ui/EditorColorSchemesUsagesCollector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKnownSchemeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

