/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JpsElementPropertiesSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;

public class ProjectStructureUsageCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(0);
        }
        Map typeNames = JBIterable.from((Iterable)JpsModelSerializerExtension.getExtensions()).flatMap(JpsModelSerializerExtension::getModuleSourceRootPropertiesSerializers).toMap(JpsElementPropertiesSerializer::getType, JpsElementPropertiesSerializer::getTypeId);
        boolean packagePrefixUsed = false;
        HashSet<UsageDescriptor> result2 = new HashSet<UsageDescriptor>();
        TObjectIntHashMap types = new TObjectIntHashMap();
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        result2.add(StatisticsUtilKt.getCountingUsage("modules.count", modules.length));
        for (Module module : modules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            result2.add(StatisticsUtilKt.getCountingUsage("content.roots.count", rootManager.getContentEntries().length));
            result2.add(StatisticsUtilKt.getCountingUsage("source.roots.count", rootManager.getSourceRoots(true).length));
            result2.add(StatisticsUtilKt.getCountingUsage("excluded.roots.count", rootManager.getExcludeRoots().length));
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder source : entry.getSourceFolders()) {
                    packagePrefixUsed = packagePrefixUsed || StringUtil.isNotEmpty((String)source.getPackagePrefix());
                    String key2 = (String)typeNames.get(source.getRootType());
                    if (key2 == null || types.increment((Object)key2)) continue;
                    types.put((Object)key2, 1);
                }
            }
            types.forEachEntry((key, count) -> result2.add(StatisticsUtilKt.getCountingUsage("source.root." + key, count)));
            types.clear();
        }
        if (PlatformUtils.isIntelliJ()) {
            result2.add(new UsageDescriptor(packagePrefixUsed ? "package.prefix.used" : "package.prefix.not.used"));
        }
        HashSet<UsageDescriptor> hashSet = result2;
        if (hashSet == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public String getGroupId() {
        if ("statistics.project.structure" == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(2);
        }
        return "statistics.project.structure";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/ProjectStructureUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/ProjectStructureUsageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

