/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.google.common.collect.HashMultiset;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.CaptureMatchData;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.regex.MatchData;

public class TextMateHighlightingLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(TextMateHighlightingLexer.class);
    private final Stack<TextMateLexerState> myStates = new Stack();
    private final Queue<Token> currentLineTokens = new LinkedList<Token>();
    private final String languageScopeName;
    private CharSequence myBuffer;
    private int myEndOffset;
    private int myCurrentOffset;
    private Token myCurrentToken;
    private final Stack<String> openedTags = new Stack();
    private final TextMateLexerState myLanguageInitialState;
    private static final int MAX_LOOPS_COUNT = 10;
    private ArrayList<TextMateLexerState> lastSuccessState;
    private int lastSuccessStateOccursCount;

    public TextMateHighlightingLexer(String scopeName, SyntaxNodeDescriptor languageRootSyntaxNode) {
        this.languageScopeName = scopeName;
        this.myLanguageInitialState = new TextMateLexerState(languageRootSyntaxNode, MatchData.NOT_MATCHED);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            TextMateHighlightingLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myCurrentOffset = startOffset;
        this.myEndOffset = endOffset;
        this.currentLineTokens.clear();
        this.initState();
        this.advance();
    }

    private void initState() {
        this.myStates.clear();
        this.myStates.push((Object)this.myLanguageInitialState);
        this.openedTags.clear();
        this.openedTags.push((Object)this.languageScopeName);
        this.setLastSuccessState(null);
    }

    public int getState() {
        return this.myCurrentToken != null ? this.myCurrentToken.state : 0;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myCurrentToken != null ? this.myCurrentToken.type : null;
    }

    public int getTokenStart() {
        return this.myCurrentToken != null ? this.myCurrentToken.startOffset : this.myEndOffset;
    }

    public int getTokenEnd() {
        return this.myCurrentToken != null ? Math.min(this.myCurrentToken.endOffset, this.myEndOffset) : this.myEndOffset;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            TextMateHighlightingLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    public void advance() {
        int endLineOffset;
        if (this.myCurrentOffset >= this.myEndOffset) {
            this.myCurrentToken = null;
            return;
        }
        if (this.currentLineTokens.isEmpty()) {
            this.restoreValidStateBeforeNewLine();
            int startLineOffset = this.myCurrentOffset;
            for (endLineOffset = this.myCurrentOffset; endLineOffset < this.myEndOffset; ++endLineOffset) {
                if (this.myBuffer.charAt(endLineOffset) != '\n') continue;
                ++endLineOffset;
                break;
            }
            this.parseLine(startLineOffset, endLineOffset);
        }
        this.myCurrentToken = this.currentLineTokens.poll();
        this.myCurrentOffset = this.myCurrentToken != null ? this.myCurrentToken.endOffset : endLineOffset;
    }

    private void restoreValidStateBeforeNewLine() {
        if (this.openedTags.empty()) {
            this.openedTags.push((Object)this.languageScopeName);
        }
    }

    private void parseLine(int startLineOffset, int endLineOffset) {
        int linePosition = 0;
        String line = this.myBuffer.subSequence(startLineOffset, endLineOffset).toString();
        if (!line.endsWith("\n")) {
            line = line + "\n";
        }
        LOG.debug("Highlighting line: " + line);
        HashMultiset localStates = HashMultiset.create();
        while (true) {
            TextMateLexerState lexerState = (TextMateLexerState)this.myStates.peek();
            if (lexerState.syntaxRule.getStringAttribute("while") == null || SyntaxMatchUtils.matchStringRegex("while", line, lexerState, linePosition).matched()) break;
            this.closeScopeSelector(linePosition + startLineOffset);
            this.closeScopeSelector(linePosition + startLineOffset);
            this.myStates.pop();
        }
        while (true) {
            Application application;
            int currentStateLocalOccurrencesCount;
            int startPosition;
            int endPosition;
            TextMateLexerState lastState = (TextMateLexerState)this.myStates.peek();
            SyntaxNodeDescriptor lastRule = lastState.syntaxRule;
            TextMateLexerState currentState = SyntaxMatchUtils.matchFirst(lastRule, line, linePosition);
            SyntaxNodeDescriptor currentRule = currentState.syntaxRule;
            MatchData currentMatch = currentState.matchData;
            MatchData endMatch = SyntaxMatchUtils.matchStringRegex("end", line, lastState, linePosition);
            if (endMatch.matched() && (!currentMatch.matched() || currentMatch.offset().getStartOffset() >= endMatch.offset().getStartOffset())) {
                this.myStates.pop();
                startPosition = endPosition = endMatch.offset().getStartOffset();
                this.closeScopeSelector(startPosition + startLineOffset);
                if (lastRule.getPlistAttribute("endCaptures") == null && lastRule.getPlistAttribute("captures") == null && lastRule.getPlistAttribute("beginCaptures") == null || this.parseCaptures("endCaptures", lastRule, endMatch, startLineOffset) || this.parseCaptures("captures", lastRule, endMatch, startLineOffset)) {
                    endPosition = endMatch.offset().getEndOffset();
                }
                this.closeScopeSelector(endPosition + startLineOffset);
            } else {
                if (!currentMatch.matched()) {
                    this.addToken(endLineOffset);
                    break;
                }
                startPosition = currentMatch.offset().getStartOffset();
                endPosition = currentMatch.offset().getEndOffset();
                if (currentRule.getRegexAttribute("begin") != null) {
                    this.openScopeSelector(currentRule.getStringAttribute("name"), startPosition + startLineOffset);
                    this.parseCaptures("beginCaptures", currentRule, currentMatch, startLineOffset);
                    this.parseCaptures("captures", currentRule, currentMatch, startLineOffset);
                    this.openScopeSelector(currentRule.getStringAttribute("contentName"), endPosition + startLineOffset);
                    this.myStates.push((Object)currentState);
                } else if (currentRule.getRegexAttribute("match") != null) {
                    this.openScopeSelector(currentRule.getStringAttribute("name"), startPosition + startLineOffset);
                    this.parseCaptures("captures", currentRule, currentMatch, startLineOffset);
                    this.closeScopeSelector(endPosition + startLineOffset);
                }
            }
            if (this.lastSuccessState != null && ContainerUtil.newArrayList(this.myStates).equals(this.lastSuccessState)) {
                ++this.lastSuccessStateOccursCount;
                if (this.lastSuccessStateOccursCount > 10) {
                    this.addToken(endLineOffset);
                    break;
                }
            }
            if ((currentStateLocalOccurrencesCount = localStates.count(this.myStates)) > 10) {
                this.addToken(endLineOffset);
                break;
            }
            localStates.setCount(this.myStates, currentStateLocalOccurrencesCount + 1);
            if (linePosition != endPosition) {
                localStates.clear();
                linePosition = endPosition;
            }
            if ((application = ApplicationManager.getApplication()) == null || application.isUnitTestMode()) continue;
            ProgressManager.checkCanceled();
        }
    }

    private void openScopeSelector(@Nullable String name, int position) {
        this.addToken(position);
        this.openedTags.push((Object)name);
    }

    private void closeScopeSelector(int position) {
        if (!this.openedTags.isEmpty() && StringUtil.isNotEmpty((String)((String)this.openedTags.peek()))) {
            this.addToken(position);
        }
        if (!this.openedTags.empty()) {
            this.openedTags.pop();
        }
    }

    private void addToken(int position) {
        if (position > this.myCurrentOffset) {
            int newState = this.openedTags.size() - 1;
            this.currentLineTokens.offer(new Token(TextMateElementType.getOrCreate(this.openedTags), this.myCurrentOffset, position, newState));
            this.myCurrentOffset = position;
            this.setLastSuccessState(ContainerUtil.newArrayList(this.myStates));
        }
    }

    private boolean parseCaptures(String capturesKey, SyntaxNodeDescriptor rule, MatchData matchData, int startLineOffset) {
        Plist captures = rule.getPlistAttribute(capturesKey);
        if (captures != null) {
            List<CaptureMatchData> matches = SyntaxMatchUtils.matchCaptures(captures, matchData);
            Stack starts = new Stack((Collection)ContainerUtil.sorted(matches, CaptureMatchData.START_OFFSET_ORDERING));
            Stack ends = new Stack((Collection)ContainerUtil.sorted(matches, CaptureMatchData.END_OFFSET_ORDERING));
            while (!starts.isEmpty() || !ends.isEmpty()) {
                CaptureMatchData start;
                CaptureMatchData end;
                if (starts.isEmpty()) {
                    end = (CaptureMatchData)ends.pop();
                    this.closeScopeSelector(startLineOffset + end.offset.getEndOffset());
                    continue;
                }
                if (ends.isEmpty()) {
                    start = (CaptureMatchData)starts.pop();
                    this.openScopeSelector(start.selectorName, startLineOffset + start.offset.getStartOffset());
                    continue;
                }
                if (((CaptureMatchData)ends.peek()).group < ((CaptureMatchData)starts.peek()).group) {
                    end = (CaptureMatchData)ends.pop();
                    this.closeScopeSelector(startLineOffset + end.offset.getEndOffset());
                    continue;
                }
                start = (CaptureMatchData)starts.pop();
                this.openScopeSelector(start.selectorName, startLineOffset + start.offset.getStartOffset());
            }
            return !matches.isEmpty();
        }
        return false;
    }

    private void setLastSuccessState(@Nullable ArrayList<TextMateLexerState> state) {
        this.lastSuccessState = state;
        this.lastSuccessStateOccursCount = 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateHighlightingLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Token {
        public final IElementType type;
        public final int startOffset;
        public final int endOffset;
        public final int state;

        private Token(IElementType type, int startOffset, int endOffset, int state) {
            this.type = type;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.state = state;
        }
    }
}

