/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import b.h.la;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithText;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.popup.NotLookupOrSearchCondition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowCoveringTestsAction
extends AnAction {
    private static final Logger a;
    private final String c;
    private final LineData b;
    private static final long d;

    public ShowCoveringTestsAction(String classFQName, LineData lineData) {
        long l2 = d ^ 0x3DE4C20E90C8L;
        super("Show tests covering line", "Show tests covering line", PlatformIcons.TEST_SOURCE_FOLDER);
        this.c = classFQName;
        this.b = lineData;
    }

    public void actionPerformed(@NotNull AnActionEvent e10) {
        long l2 = d ^ 0x363C04B3D324L;
        if (e10 == null) {
            ShowCoveringTestsAction.a(0);
        }
        DataContext dataContext = e10.getDataContext();
        Project project = e10.getProject();
        a.assertTrue(project != null);
        Editor editor = (Editor)e10.getData(CommonDataKeys.EDITOR);
        a.assertTrue(editor != null);
        CoverageSuitesBundle coverageSuitesBundle = CoverageDataManager.getInstance(project).getCurrentSuitesBundle();
        a.assertTrue(coverageSuitesBundle != null);
        File[] fileArray = ShowCoveringTestsAction.a(project);
        HashSet hashSet = new HashSet();
        Runnable runnable = () -> {
            for (File file : fileArray) {
                FilterInputStream filterInputStream = null;
                try {
                    filterInputStream = new DataInputStream(new FileInputStream(file));
                    this.a(file, (DataInputStream)filterInputStream, hashSet);
                }
                catch (Exception exception) {
                    a.error(file.getName(), (Throwable)exception);
                }
                finally {
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException) {
                        a.error((Throwable)iOException);
                    }
                }
            }
        };
        if (ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, "Extract information about tests", false, project)) {
            PanelWithText panelWithText;
            ComponentPopupBuilder componentPopupBuilder;
            ImplementationViewComponent implementationViewComponent;
            Object[] objectArray = ArrayUtil.toStringArray(hashSet);
            Arrays.sort(objectArray);
            if (objectArray.length == 0) {
                HintManager.getInstance().showErrorHint(editor, "Failed to load covered tests");
                return;
            }
            List<PsiElement> list2 = coverageSuitesBundle.getCoverageEngine().findTestsByNames((String[])objectArray, project);
            String string = "Tests covering line " + this.c + ":" + this.b.getLineNumber();
            if (!list2.isEmpty()) {
                implementationViewComponent = new ImplementationViewComponent(PsiUtilCore.toPsiElementArray(list2), 0);
                componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)implementationViewComponent, implementationViewComponent.getPreferredFocusableComponent()).setDimensionServiceKey(project, "ShowTestsPopup", false).setCouldPin(jBPopup -> {
                    implementationViewComponent.showInUsageView();
                    jBPopup.cancel();
                    return false;
                });
            } else {
                implementationViewComponent = null;
                panelWithText = new PanelWithText("Following test" + (objectArray.length > 1 ? "s" : "") + " could not be found: " + StringUtil.join((String[])objectArray, (String)"<br/>").replace("_", "."));
                componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panelWithText, null);
            }
            panelWithText = componentPopupBuilder.setRequestFocusCondition(project, (Condition)NotLookupOrSearchCondition.INSTANCE).setProject(project).setResizable(true).setMovable(true).setTitle(string).createPopup();
            panelWithText.showInBestPositionFor(editor);
            if (implementationViewComponent != null) {
                implementationViewComponent.setHint((JBPopup)panelWithText, string);
            }
        }
    }

    private void a(File file, DataInputStream dataInputStream, Set<String> set) throws IOException {
        long l2 = dataInputStream.readInt();
        int n2 = 0;
        while ((long)n2 < l2) {
            String string = dataInputStream.readUTF();
            int n3 = dataInputStream.readInt();
            for (int i10 = 0; i10 < n3; ++i10) {
                int n4 = dataInputStream.readInt();
                if (!Comparing.strEqual((String)string, (String)this.c) || this.b.getLineNumber() != n4) continue;
                set.add(FileUtil.getNameWithoutExtension((File)file));
                return;
            }
            ++n2;
        }
    }

    public void update(@NotNull AnActionEvent e10) {
        File[] fileArray;
        Project project;
        if (e10 == null) {
            ShowCoveringTestsAction.a(1);
        }
        Presentation presentation = e10.getPresentation();
        presentation.setEnabled(false);
        if (this.b != null && this.b.getStatus() != 0 && (project = e10.getProject()) != null && (fileArray = ShowCoveringTestsAction.a(project)) != null && fileArray.length > 0) {
            presentation.setEnabled(CoverageDataManager.getInstance(project).getCurrentSuitesBundle().isCoverageByTestEnabled());
        }
    }

    @Nullable
    private static File[] a(Project project) {
        CoverageSuitesBundle coverageSuitesBundle = CoverageDataManager.getInstance(project).getCurrentSuitesBundle();
        if (coverageSuitesBundle == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (CoverageSuite coverageSuite : coverageSuitesBundle.getSuites()) {
            String string = coverageSuite.getCoverageDataFileName();
            String string2 = FileUtil.getNameWithoutExtension((String)new File(string).getName());
            File file = new File(string).getParentFile();
            File file2 = new File(file, string2);
            File[] fileArray = file2.listFiles();
            if (fileArray == null) continue;
            Collections.addAll(arrayList, fileArray);
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new File[0]);
    }

    static {
        d = la.a(-824729941446245897L, 7989805114532095733L, MethodHandles.lookup().lookupClass()).a(212023896045118L);
        a = Logger.getInstance(ShowCoveringTestsAction.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = d ^ 0x2341C2F55655L;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/coverage/actions/ShowCoveringTestsAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

