/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.collections;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0002\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00028\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0011\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0003H\u0096\u0001J\u0016\u0010 \u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\t\u0010\"\u001a\u00020\u001dH\u0096\u0001R$\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\n0\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0003X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/jetbrains/rd/util/collections/CountingSet;", "T", "", "", "()V", "map", "", "(Ljava/util/Map;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "getMap", "()Ljava/util/Map;", "size", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "add", "key", "value", "(Ljava/lang/Object;I)I", "containsKey", "", "(Ljava/lang/Object;)Z", "containsValue", "get", "(Ljava/lang/Object;)Ljava/lang/Integer;", "isEmpty", "rd-core"})
public final class CountingSet<T>
implements Map<T, Integer>,
KMappedMarker {
    @NotNull
    private final Map<T, Integer> map;

    private CountingSet(Map<T, Integer> map2) {
        this.map = map2;
    }

    @NotNull
    public final Map<T, Integer> getMap() {
        return this.map;
    }

    @NotNull
    public Set<Map.Entry<T, Integer>> getEntries() {
        return this.map.entrySet();
    }

    @NotNull
    public Set<T> getKeys() {
        return this.map.keySet();
    }

    public int getSize() {
        return this.map.size();
    }

    @NotNull
    public Collection<Integer> getValues() {
        return this.map.values();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(int value2) {
        return this.map.containsValue(value2);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public CountingSet() {
        this(new LinkedHashMap());
    }

    public final int add(T key, int value2) {
        Integer n = this.map.get(key);
        int old = n != null ? n : 0;
        int n2 = old + value2;
        if (n2 == 0) {
            this.map.remove(key);
        } else {
            Integer n3 = n2;
            this.map.put(key, n3);
        }
        return n2;
    }

    @Override
    @NotNull
    public Integer get(T key) {
        Integer n = this.map.get(key);
        return n != null ? n : 0;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Integer compute(T p0, BiFunction<? super T, ? super Integer, ? extends Integer> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Integer computeIfAbsent(T p0, Function<? super T, ? extends Integer> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Integer computeIfPresent(T p0, BiFunction<? super T, ? super Integer, ? extends Integer> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Integer merge(T p0, Integer p1, BiFunction<? super Integer, ? super Integer, ? extends Integer> p2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Integer put(T key, int value2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void putAll(Map<? extends T, ? extends Integer> from) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Integer putIfAbsent(T p0, Integer p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Integer remove(Object key) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object key, Object value2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean replace(T p0, Integer p1, Integer p2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Integer replace(T p0, Integer p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(BiFunction<? super T, ? super Integer, ? extends Integer> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

