/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.testFramework.EmptyFileBasedIndex;
import com.intellij.testFramework.NeedsIndex;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.junit.internal.MethodSorter;
import org.junit.runner.Describable;
import org.junit.runner.Description;

public interface TestIndexingModeSupporter {
    public void setIndexingMode(@NotNull IndexingMode var1);

    @NotNull
    public IndexingMode getIndexingMode();

    public static void addTest(@NotNull Class<? extends TestIndexingModeSupporter> aClass, @NotNull IndexingModeTestHandler handler, @NotNull TestSuite parentSuite) {
        if (aClass == null) {
            TestIndexingModeSupporter.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            TestIndexingModeSupporter.$$$reportNull$$$0(1);
        }
        if (parentSuite == null) {
            TestIndexingModeSupporter.$$$reportNull$$$0(2);
        }
        if (handler.shouldIgnore(aClass)) {
            return;
        }
        try {
            TestSuite suite = handler.createTestSuite();
            suite.setName(aClass.getSimpleName());
            boolean foundTests = false;
            Constructor<? extends TestIndexingModeSupporter> constructor = aClass.getConstructor(new Class[0]);
            for (Method declaredMethod : MethodSorter.getDeclaredMethods(aClass)) {
                String methodName;
                if (!Modifier.isPublic(declaredMethod.getModifiers()) || !(methodName = declaredMethod.getName()).startsWith("test") || TestFrameworkUtil.isPerformanceTest(methodName, aClass.getName()) || handler.shouldIgnore(declaredMethod)) continue;
                TestIndexingModeSupporter aCase = constructor.newInstance(new Object[0]);
                aCase.setIndexingMode(handler.getIndexingMode());
                if (aCase instanceof TestCase) {
                    TestCase testCase = (TestCase)aCase;
                    testCase.setName(methodName);
                    if (UsefulTestCase.IS_UNDER_TEAMCITY) {
                        Test wrapper = IndexingModeTestHandler.wrapForTeamCity(testCase, handler.getIndexingMode());
                        suite.addTest(wrapper);
                    } else {
                        suite.addTest((Test)testCase);
                    }
                } else {
                    parentSuite.addTest(TestSuite.warning((String)(aClass.getName() + "is not a TestSuite")));
                }
                foundTests = true;
            }
            if (foundTests) {
                parentSuite.addTest((Test)suite);
            }
        }
        catch (NoSuchMethodException e) {
            parentSuite.addTest(TestSuite.warning((String)("Failed to find default constructor for " + aClass.getName() + ", see log")));
            e.printStackTrace();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            parentSuite.addTest(TestSuite.warning((String)("Failed to instantiate " + aClass.getName() + ", see log")));
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "handler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parentSuite";
                break;
            }
        }
        objectArray[1] = "com/intellij/testFramework/TestIndexingModeSupporter";
        objectArray[2] = "addTest";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class IndexingModeTestHandler {
        public final String myTestSuiteName;
        public final String myTestNamePrefix;
        private final IndexingMode myIndexingMode;

        protected IndexingModeTestHandler(@NotNull String testSuiteName, @NotNull String testNamePrefix, @NotNull IndexingMode mode) {
            if (testSuiteName == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(0);
            }
            if (testNamePrefix == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(1);
            }
            if (mode == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(2);
            }
            this.myTestSuiteName = testSuiteName;
            this.myTestNamePrefix = testNamePrefix;
            this.myIndexingMode = mode;
        }

        public TestSuite createTestSuite() {
            return new NamedTestSuite(this.myTestNamePrefix);
        }

        public abstract boolean shouldIgnore(@NotNull AnnotatedElement var1);

        @NotNull
        public IndexingMode getIndexingMode() {
            IndexingMode indexingMode = this.myIndexingMode;
            if (indexingMode == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(3);
            }
            return indexingMode;
        }

        private static boolean shouldIgnoreInFullIndexSuite(@NotNull AnnotatedElement element) {
            if (element == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(4);
            }
            return element.isAnnotationPresent(NeedsIndex.SmartMode.class);
        }

        private static boolean shouldIgnoreInRuntimeOnlyIndexSuite(@NotNull AnnotatedElement element) {
            if (element == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(5);
            }
            return IndexingModeTestHandler.shouldIgnoreInFullIndexSuite(element) || element.isAnnotationPresent(NeedsIndex.Full.class);
        }

        private static boolean shouldIgnoreInEmptyIndexSuite(@NotNull AnnotatedElement element) {
            if (element == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(6);
            }
            return IndexingModeTestHandler.shouldIgnoreInRuntimeOnlyIndexSuite(element) || element.isAnnotationPresent(NeedsIndex.ForStandardLibrary.class);
        }

        private static Test wrapForTeamCity(@NotNull TestCase testCase, @NotNull IndexingMode mode) {
            if (testCase == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(7);
            }
            if (mode == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(8);
            }
            return new MyHackyJUnitTaskMirrorImpl.VmExitErrorTest(testCase, mode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testSuiteName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testNamePrefix";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingModeTestHandler";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testCase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingModeTestHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexingMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldIgnoreInFullIndexSuite";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldIgnoreInRuntimeOnlyIndexSuite";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldIgnoreInEmptyIndexSuite";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapForTeamCity";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }

        private static final class NamedTestSuite
        extends TestSuite {
            private final String myPrefix;

            private NamedTestSuite(@NotNull String prefix) {
                if (prefix == null) {
                    NamedTestSuite.$$$reportNull$$$0(0);
                }
                this.myPrefix = prefix;
            }

            public void setName(String name) {
                super.setName(this.myPrefix + name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/testFramework/TestIndexingModeSupporter$IndexingModeTestHandler$NamedTestSuite", "<init>"));
            }
        }

        private static class MyHackyJUnitTaskMirrorImpl {
            private MyHackyJUnitTaskMirrorImpl() {
            }

            private static class VmExitErrorTest
            implements Test,
            Describable {
                private final TestCase myTestCase;
                private final IndexingMode myMode;

                private VmExitErrorTest(@NotNull TestCase testCase, @NotNull IndexingMode mode) {
                    if (testCase == null) {
                        VmExitErrorTest.$$$reportNull$$$0(0);
                    }
                    if (mode == null) {
                        VmExitErrorTest.$$$reportNull$$$0(1);
                    }
                    this.myTestCase = testCase;
                    this.myMode = mode;
                }

                public int countTestCases() {
                    return this.myTestCase.countTestCases();
                }

                public void run(TestResult result2) {
                    result2.startTest((Test)this);
                    Protectable p = new Protectable(){

                        public void protect() throws Throwable {
                            myTestCase.runBare();
                        }
                    };
                    result2.runProtected((Test)this, p);
                    result2.endTest((Test)this);
                }

                public String toString() {
                    return this.myTestCase.getClass().getName() + "." + this.myTestCase.getName() + " with IndexingMode " + this.myMode.name();
                }

                public Description getDescription() {
                    return Description.createTestDescription(this.myTestCase.getClass(), (String)(this.myTestCase.getName() + "[" + this.myMode.name() + "]"));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "testCase";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "mode";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingModeTestHandler$MyHackyJUnitTaskMirrorImpl$VmExitErrorTest";
                    objectArray[2] = "<init>";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum IndexingMode {
        SMART{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (testRootDisposable == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void tearDownTest(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testRootDisposable";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingMode$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setUpTest";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "tearDownTest";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DUMB_FULL_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (testRootDisposable == null) {
                    2.$$$reportNull$$$0(1);
                }
                IndexingMode.indexEverythingAndBecomeDumb(project2);
                RecursionManager.disableMissedCacheAssertions((Disposable)testRootDisposable);
            }

            @Override
            public void ensureIndexingStatus(@NotNull Project project2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                DumbServiceImpl dumbService = DumbServiceImpl.getInstance((Project)project2);
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    dumbService.setDumb(false);
                    new UnindexedFilesUpdater(project2).queue();
                    dumbService.setDumb(true);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testRootDisposable";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingMode$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setUpTest";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "ensureIndexingStatus";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DUMB_RUNTIME_ONLY_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                if (project2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (testRootDisposable == null) {
                    3.$$$reportNull$$$0(1);
                }
                IndexingMode.becomeDumb(project2);
                RecursionManager.disableMissedCacheAssertions((Disposable)testRootDisposable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "testRootDisposable";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingMode$3";
                objectArray[2] = "setUpTest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DUMB_EMPTY_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                if (project2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (testRootDisposable == null) {
                    4.$$$reportNull$$$0(1);
                }
                ServiceContainerUtil.replaceService((ComponentManager)ApplicationManager.getApplication(), FileBasedIndex.class, new EmptyFileBasedIndex(), testRootDisposable);
                IndexingMode.becomeDumb(project2);
                RecursionManager.disableMissedCacheAssertions((Disposable)testRootDisposable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "testRootDisposable";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingMode$4";
                objectArray[2] = "setUpTest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        public abstract void setUpTest(@NotNull Project var1, @NotNull Disposable var2);

        public void tearDownTest(@NotNull Project project2) {
            if (project2 == null) {
                IndexingMode.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().invokeAndWait(() -> DumbServiceImpl.getInstance((Project)project2).setDumb(false));
        }

        public void ensureIndexingStatus(@NotNull Project project2) {
            if (project2 == null) {
                IndexingMode.$$$reportNull$$$0(1);
            }
        }

        private static void becomeDumb(@NotNull Project project2) {
            if (project2 == null) {
                IndexingMode.$$$reportNull$$$0(2);
            }
            ApplicationManager.getApplication().invokeAndWait(() -> DumbServiceImpl.getInstance((Project)project2).setDumb(true));
        }

        private static void indexEverythingAndBecomeDumb(@NotNull Project project2) {
            if (project2 == null) {
                IndexingMode.$$$reportNull$$$0(3);
            }
            DumbServiceImpl dumbService = DumbServiceImpl.getInstance((Project)project2);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                dumbService.setDumb(false);
                new UnindexedFilesUpdater(project2).queue();
                dumbService.setDumb(true);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingMode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tearDownTest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ensureIndexingStatus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "becomeDumb";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexEverythingAndBecomeDumb";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class EmptyIndexSuite
    extends IndexingModeTestHandler {
        public EmptyIndexSuite() {
            super("Empty index", "Empty index ", IndexingMode.DUMB_EMPTY_INDEX);
        }

        @Override
        public boolean shouldIgnore(@NotNull AnnotatedElement aClass) {
            if (aClass == null) {
                EmptyIndexSuite.$$$reportNull$$$0(0);
            }
            return IndexingModeTestHandler.shouldIgnoreInEmptyIndexSuite(aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/testFramework/TestIndexingModeSupporter$EmptyIndexSuite", "shouldIgnore"));
        }
    }

    public static class RuntimeOnlyIndexSuite
    extends IndexingModeTestHandler {
        public RuntimeOnlyIndexSuite() {
            super("RuntimeOnlyIndex", "Runtime only index ", IndexingMode.DUMB_RUNTIME_ONLY_INDEX);
        }

        @Override
        public boolean shouldIgnore(@NotNull AnnotatedElement aClass) {
            if (aClass == null) {
                RuntimeOnlyIndexSuite.$$$reportNull$$$0(0);
            }
            return IndexingModeTestHandler.shouldIgnoreInRuntimeOnlyIndexSuite(aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/testFramework/TestIndexingModeSupporter$RuntimeOnlyIndexSuite", "shouldIgnore"));
        }
    }

    public static class FullIndexSuite
    extends IndexingModeTestHandler {
        public FullIndexSuite() {
            super("Full index", "Full index ", IndexingMode.DUMB_FULL_INDEX);
        }

        @Override
        public boolean shouldIgnore(@NotNull AnnotatedElement aClass) {
            if (aClass == null) {
                FullIndexSuite.$$$reportNull$$$0(0);
            }
            return IndexingModeTestHandler.shouldIgnoreInFullIndexSuite(aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/testFramework/TestIndexingModeSupporter$FullIndexSuite", "shouldIgnore"));
        }
    }
}

