/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.validation.AssignTargetAnnotator;
import com.jetbrains.python.validation.BreakContinueAnnotator;
import com.jetbrains.python.validation.GlobalAnnotator;
import com.jetbrains.python.validation.HighlightingAnnotator;
import com.jetbrains.python.validation.ImportAnnotator;
import com.jetbrains.python.validation.ParameterListAnnotator;
import com.jetbrains.python.validation.PyAnnotator;
import com.jetbrains.python.validation.PyAsyncAwaitAnnotator;
import com.jetbrains.python.validation.PyBuiltinAnnotator;
import com.jetbrains.python.validation.ReturnAnnotator;
import com.jetbrains.python.validation.TryExceptAnnotator;
import com.jetbrains.python.validation.TypeAnnotationTargetAnnotator;
import com.jetbrains.python.validation.UnsupportedFeatures;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PyAnnotatingVisitor
implements Annotator {
    private static final Logger LOGGER = Logger.getInstance((String)PyAnnotatingVisitor.class.getName());
    private static final Class[] ANNOTATOR_CLASSES = new Class[]{AssignTargetAnnotator.class, TypeAnnotationTargetAnnotator.class, ParameterListAnnotator.class, HighlightingAnnotator.class, ReturnAnnotator.class, TryExceptAnnotator.class, BreakContinueAnnotator.class, GlobalAnnotator.class, ImportAnnotator.class, PyBuiltinAnnotator.class, UnsupportedFeatures.class, PyAsyncAwaitAnnotator.class};
    private final PyAnnotator[] myAnnotators;

    public PyAnnotatingVisitor() {
        ArrayList<PyAnnotator> annotators = new ArrayList<PyAnnotator>();
        for (Class cls : ANNOTATOR_CLASSES) {
            PyAnnotator annotator;
            try {
                annotator = (PyAnnotator)((Object)cls.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            annotators.add(annotator);
        }
        this.myAnnotators = annotators.toArray(new PyAnnotator[0]);
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            PyAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PyAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        PyAnnotatingVisitor.runAnnotators(psiElement, holder, this.myAnnotators);
    }

    static void runAnnotators(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder, PyAnnotator[] annotators) {
        if (psiElement == null) {
            PyAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PyAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        for (PyAnnotator annotator : annotators) {
            if (file instanceof PyFileImpl && !((PyFileImpl)file).isAcceptedFor(((Object)((Object)annotator)).getClass())) continue;
            annotator.annotateElement(psiElement, holder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyAnnotatingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runAnnotators";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

