/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors.conda;

import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.EnvReader;
import com.intellij.util.io.PathKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.flavors.conda.PyCondaFlavorData;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a1\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u000f\u0010\n\u001a\u000b0\tj\u0002`\u000b\u00a2\u0006\u0002\b\fH\u0002\u001a\u001b\u0010\r\u001a\u00020\u0006*\u00020\u00022\u000f\u0010\n\u001a\u000b0\tj\u0002`\u000b\u00a2\u0006\u0002\b\f\u001a\u0012\u0010\r\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"localOnWindows", "", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "getLocalOnWindows", "(Lcom/intellij/execution/target/TargetedCommandLineBuilder;)Z", "addEnvVars", "", "envs", "", "", "condaPathOnTarget", "Lcom/intellij/execution/target/FullPathOnTarget;", "Lcom/intellij/openapi/util/NlsSafe;", "fixCondaPathEnvIfNeeded", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.python.community.impl"})
public final class CondaPathFixKt {
    public static final void fixCondaPathEnvIfNeeded(@NotNull TargetedCommandLineBuilder $this$fixCondaPathEnvIfNeeded, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)$this$fixCondaPathEnvIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        if (!CondaPathFixKt.getLocalOnWindows($this$fixCondaPathEnvIfNeeded)) {
            return;
        }
        Object obj = PySdkExtKt.getOrCreateAdditionalData(sdk2).getFlavorAndData().getData();
        PyCondaFlavorData pyCondaFlavorData = obj instanceof PyCondaFlavorData ? (PyCondaFlavorData)obj : null;
        if (pyCondaFlavorData == null) {
            return;
        }
        PyCondaFlavorData condaData = pyCondaFlavorData;
        String pythonHomePath = sdk2.getHomePath();
        if (pythonHomePath == null) {
            Logger.getInstance((String)"Conda").warn("No home path for " + $this$fixCondaPathEnvIfNeeded + ", will skip 'venv activation'");
            return;
        }
        Map<String, String> map = PySdkUtil.activateVirtualEnv(sdk2);
        Intrinsics.checkNotNullExpressionValue(map, (String)"activateVirtualEnv(sdk)");
        CondaPathFixKt.addEnvVars($this$fixCondaPathEnvIfNeeded, map, condaData.getEnv().getFullCondaPathOnTarget());
    }

    public static final void fixCondaPathEnvIfNeeded(@NotNull TargetedCommandLineBuilder $this$fixCondaPathEnvIfNeeded, @NotNull String condaPathOnTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$fixCondaPathEnvIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)condaPathOnTarget, (String)"condaPathOnTarget");
        if (!CondaPathFixKt.getLocalOnWindows($this$fixCondaPathEnvIfNeeded)) {
            return;
        }
        Path condaPath = Path.of(condaPathOnTarget, new String[0]);
        Logger logger = Logger.getInstance((String)"Conda");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"Conda\")");
        Logger logger2 = logger;
        Intrinsics.checkNotNullExpressionValue((Object)condaPath, (String)"condaPath");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(condaPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger2.warn(condaPath + " doesn't exist");
            return;
        }
        Path activateBat = condaPath.resolveSibling("activate.bat");
        Intrinsics.checkNotNullExpressionValue((Object)activateBat, (String)"activateBat");
        if (!Files.isExecutable(activateBat)) {
            logger2.warn(activateBat + " doesn't exist or can't be read");
            return;
        }
        try {
            Map map = new EnvReader().readBatEnv(activateBat, CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"EnvReader().readBatEnv(activateBat, emptyList())");
            Map envs = map;
            CondaPathFixKt.addEnvVars($this$fixCondaPathEnvIfNeeded, envs, condaPathOnTarget);
        }
        catch (IOException e) {
            logger2.warn("Can't read env vars", (Throwable)e);
        }
    }

    private static final boolean getLocalOnWindows(TargetedCommandLineBuilder $this$localOnWindows) {
        TargetEnvironmentRequest it = $this$localOnWindows.getRequest();
        boolean bl = false;
        return it.getTargetPlatform().getPlatform() == Platform.WINDOWS && it.getConfiguration() == null;
    }

    private static final void addEnvVars(TargetedCommandLineBuilder $this$addEnvVars, Map<String, String> envs, String condaPathOnTarget) {
        Path extraPath;
        block4: {
            block3: {
                Path path2 = Path.of(condaPathOnTarget, new String[0]).getParent();
                Path path3 = path2 != null && (path2 = path2.getParent()) != null && (path2 = path2.resolve("Library")) != null ? path2.resolve("Bin") : (extraPath = null);
                if (extraPath == null) break block3;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(extraPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && PathKt.isDirectory((Path)extraPath)) break block4;
            }
            Logger.getInstance((String)"Conda").warn(extraPath + " doesn't exist");
        }
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            String fixedVal = StringsKt.equals((String)k, (String)"Path", (boolean)true) && extraPath != null ? v + $this$addEnvVars.getRequest().getTargetPlatform().getPlatform().pathSeparator + extraPath : v;
            $this$addEnvVars.addEnvironmentVariable(k, fixedVal);
        }
    }
}

