/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.sdk.AddInterpreterActions;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/sdk/AddInterpreterAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "currentSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.community.impl"})
public final class AddInterpreterAction
extends DumbAwareAction {
    @NotNull
    private final Project project;
    @NotNull
    private final Module module;
    @Nullable
    private final Sdk currentSdk;

    public AddInterpreterAction(@NotNull Project project, @NotNull Module module, @Nullable Sdk currentSdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super(PyBundle.messagePointer("python.sdk.popup.add.interpreter", new Object[0]));
        this.project = project;
        this.module = module;
        this.currentSdk = currentSdk;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ProjectSdksModel model2 = PyConfigurableInterpreterList.getInstance(this.project).getModel();
        Sdk[] sdkArray = model2.getSdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"model.sdks");
        PyAddSdkDialog.Companion.show(this.project, this.module, ArraysKt.asList((Object[])sdkArray), arg_0 -> AddInterpreterAction.actionPerformed$lambda$0(model2, this, arg_0));
    }

    private static final void actionPerformed$lambda$0(ProjectSdksModel $model, AddInterpreterAction this$0, Sdk it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (it != null && $model.findSdk(it.getName()) == null) {
            $model.addSdk(it);
            $model.apply();
            AddInterpreterActions.switchToSdk(this$0.module, it, this$0.currentSdk);
        }
    }
}

