/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.net.HostAndPort;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.BaseRemoteProcessHandler;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.RemoteDebuggableProcessHandler;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PyRemoteProcessHandler
extends BaseRemoteProcessHandler<RemoteProcess>
implements RemoteDebuggableProcessHandler,
KillableProcess,
AnsiEscapeDecoder.ColoredTextAcceptor {
    private static final Logger LOG = Logger.getInstance(PyRemoteProcessHandler.class);
    private final AnsiEscapeDecoder myAnsiEscapeDecoder;
    public static final String LOG_PY_CHARM_FILE_MAPPING = "LOG: PyCharm: File mapping:";
    @NotNull
    private final PyRemotePathMapper myPathMapper;
    private final List<PathMappingSettings.PathMapping> myFileMappings;
    @NotNull
    private final PyRemoteSocketToLocalHostProvider myRemoteSocketProvider;
    private final boolean myIsRunWithPty;

    private PyRemoteProcessHandler(@NotNull RemoteProcess process2, @NotNull String commandLine, @NotNull Charset charset, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider, boolean isRunWithPty) {
        if (process2 == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(2);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(3);
        }
        super(process2, commandLine, charset);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myFileMappings = new ArrayList<PathMappingSettings.PathMapping>();
        this.myRemoteSocketProvider = remoteSocketProvider;
        this.myPathMapper = pathMapper != null ? pathMapper : new PyRemotePathMapper();
        this.myIsRunWithPty = isRunWithPty;
    }

    @NotNull
    public PathMapper getMappingSettings() {
        PyRemotePathMapper pyRemotePathMapper = this.myPathMapper;
        if (pyRemotePathMapper == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(4);
        }
        return pyRemotePathMapper;
    }

    public Pair<String, Integer> getRemoteSocket(int localPort) throws RemoteSdkException {
        try {
            return this.myRemoteSocketProvider.getRemoteSocket(localPort);
        }
        catch (RemoteSdkException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return ((RemoteProcess)this.myProcess).getLocalTunnel(remotePort);
    }

    public boolean canKillProcess() {
        return true;
    }

    public void killProcess() {
        this.destroyProcessImpl();
    }

    @NotNull
    public static PyRemoteProcessHandler createProcessHandler(@NotNull RemoteProcess remoteProcess, @NotNull RemoteSdkCredentials data, @NotNull GeneralCommandLine commandLine, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) throws RemoteSdkException {
        if (remoteProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(5);
        }
        if (data == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(7);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(8);
        }
        return PyRemoteProcessHandler.createProcessHandler(remoteProcess, data.getFullInterpreterPath(), commandLine, pathMapper, remoteSocketProvider);
    }

    @NotNull
    public static PyRemoteProcessHandler createProcessHandler(@NotNull RemoteProcess remoteProcess, @Nullable String fullInterpreterPath, @NotNull GeneralCommandLine commandLine, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) throws RemoteSdkException {
        if (remoteProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(9);
        }
        if (commandLine == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(10);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(11);
        }
        return new PyRemoteProcessHandler(remoteProcess, commandLine.getCommandLineString(fullInterpreterPath), commandLine.getCharset(), pathMapper, remoteSocketProvider, false);
    }

    @NotNull
    public static PyRemoteProcessHandler createProcessHandler(@NotNull RemoteProcess remoteProcess, @NotNull String commandLine, @NotNull Charset charset, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider, boolean isRunWithPty) {
        if (remoteProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(12);
        }
        if (commandLine == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(13);
        }
        if (charset == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(14);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(15);
        }
        return new PyRemoteProcessHandler(remoteProcess, commandLine, charset, pathMapper, remoteSocketProvider, isRunWithPty);
    }

    @NotNull
    public static PyRemoteProcessHandler createProcessHandler(@NotNull RemoteProcess remoteProcess, @NotNull String commandLine, @NotNull Charset charset, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        if (remoteProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(16);
        }
        if (commandLine == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(17);
        }
        if (charset == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(18);
        }
        if (remoteSocketProvider == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(19);
        }
        return PyRemoteProcessHandler.createProcessHandler(remoteProcess, commandLine, charset, pathMapper, remoteSocketProvider, false);
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(20);
        }
        if (outputType == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(21);
        }
        if (this.isRunWithPty()) {
            boolean foundPyCharmFileMapping = this.handlePyCharmFileMapping(text);
            if (!foundPyCharmFileMapping) {
                super.notifyTextAvailable(text, outputType);
            }
        } else {
            this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
        }
    }

    private boolean handlePyCharmFileMapping(@NotNull String text) {
        if (text == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(22);
        }
        if (text.startsWith(LOG_PY_CHARM_FILE_MAPPING)) {
            String[] paths = (text = text.substring(LOG_PY_CHARM_FILE_MAPPING.length())).split("\t");
            if (paths.length == 2) {
                this.myFileMappings.add(new PathMappingSettings.PathMapping(paths[0].trim(), paths[1].trim()));
            } else {
                LOG.warn("Can't parse remote file mapping " + text);
            }
            return true;
        }
        return false;
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key outputType) {
        boolean foundPyCharmFileMapping;
        if (text == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(23);
        }
        if (outputType == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(24);
        }
        if (!(foundPyCharmFileMapping = this.handlePyCharmFileMapping(text))) {
            super.notifyTextAvailable(text, outputType);
        }
    }

    public boolean isRunWithPty() {
        return this.myIsRunWithPty;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BaseOutputReader.Options readerOptions() {
        if (this.isRunWithPty()) {
            BaseOutputReader.Options options = BaseOutputReader.Options.forTerminalPtyProcess();
            if (options == null) {
                PyRemoteProcessHandler.$$$reportNull$$$0(25);
            }
            return options;
        }
        BaseOutputReader.Options options = super.readerOptions();
        if (options == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(26);
        }
        return options;
    }

    public List<PathMappingSettings.PathMapping> getFileMappings() {
        return this.myFileMappings;
    }

    @Override
    @NotNull
    public PyPositionConverter createPositionConverter(@NotNull PyDebugProcess debugProcess) {
        if (debugProcess == null) {
            PyRemoteProcessHandler.$$$reportNull$$$0(27);
        }
        return new PyRemotePositionConverter(debugProcess, this.myPathMapper);
    }

    @Override
    public PyRemoteSocketToLocalHostProvider getRemoteSocketToLocalHostProvider() {
        return this.myRemoteSocketProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSocketProvider";
                break;
            }
            case 4: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteProcessHandler";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteProcessHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingSettings";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "readerOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 25: 
            case 26: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "notifyTextAvailable";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "handlePyCharmFileMapping";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "coloredTextAvailable";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createPositionConverter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 25, 26 -> new IllegalStateException(string);
        };
    }
}

