/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralDecoder {
    public static final Pattern PATTERN_ESCAPE = Pattern.compile("(\\{\\{|}})|\\\\(\n|\\\\|'|\"|a|b|f|n|r|t|v|([0-7]{1,3})|x([0-9a-fA-F]{1,2})|N(\\{.*?})|u([0-9a-fA-F]{4})|U([0-9a-fA-F]{8}))");
    private static final Map<String, String> escapeMap = PyStringLiteralDecoder.initializeEscapeMap();
    private final PyStringElement myNode;

    @NotNull
    private static Map<String, String> initializeEscapeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\n", "\n");
        map.put("\\", "\\");
        map.put("'", "'");
        map.put("\"", "\"");
        map.put("a", "\u0001");
        map.put("b", "\b");
        map.put("f", "\f");
        map.put("n", "\n");
        map.put("r", "\r");
        map.put("t", "\t");
        map.put("v", "\u000b");
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            PyStringLiteralDecoder.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    public PyStringLiteralDecoder(@NotNull PyStringElement node) {
        if (node == null) {
            PyStringLiteralDecoder.$$$reportNull$$$0(1);
        }
        this.myNode = node;
    }

    @NotNull
    public List<Pair<TextRange, String>> decodeContent() {
        List<Pair<TextRange, String>> list = this.decodeRange(this.myNode.getContentRange());
        if (list == null) {
            PyStringLiteralDecoder.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<Pair<TextRange, String>> decodeRange(@NotNull TextRange range) {
        if (range == null) {
            PyStringLiteralDecoder.$$$reportNull$$$0(3);
        }
        return this.decodeFragment(range.substring(this.myNode.getText()), range.getStartOffset());
    }

    @NotNull
    private List<Pair<TextRange, String>> decodeFragment(@NotNull String encoded, int offset) {
        TextRange range;
        if (encoded == null) {
            PyStringLiteralDecoder.$$$reportNull$$$0(4);
        }
        boolean raw = this.myNode.isRaw();
        boolean unicode = this.myNode.isUnicode() || this.isUnicodeByDefault();
        boolean formatted = this.myNode.isFormatted();
        ArrayList<Pair<TextRange, String>> result2 = new ArrayList<Pair<TextRange, String>>();
        Matcher escMatcher = PATTERN_ESCAPE.matcher(encoded);
        int index = 0;
        while (escMatcher.find(index)) {
            String str;
            boolean escapedUnicode;
            if (index < escMatcher.start()) {
                range = TextRange.create((int)index, (int)escMatcher.start());
                TextRange offsetRange = range.shiftRight(offset);
                result2.add(Pair.create((Object)offsetRange, (Object)range.substring(encoded)));
            }
            String fStringBrace = PyStringLiteralDecoder.escapeRegexGroup(escMatcher, EscapeRegexGroup.FSTRING_BRACE);
            String octal = PyStringLiteralDecoder.escapeRegexGroup(escMatcher, EscapeRegexGroup.OCTAL);
            String hex = PyStringLiteralDecoder.escapeRegexGroup(escMatcher, EscapeRegexGroup.HEXADECIMAL);
            String unicode16 = PyStringLiteralDecoder.escapeRegexGroup(escMatcher, EscapeRegexGroup.UNICODE_16BIT);
            String unicode32 = PyStringLiteralDecoder.escapeRegexGroup(escMatcher, EscapeRegexGroup.UNICODE_32BIT);
            String wholeMatch = PyStringLiteralDecoder.escapeRegexGroup(escMatcher, EscapeRegexGroup.WHOLE_MATCH);
            assert (wholeMatch != null);
            boolean bl = escapedUnicode = !raw || unicode;
            if (fStringBrace != null) {
                str = formatted ? wholeMatch.substring(0, 1) : wholeMatch;
            } else if (!raw && octal != null) {
                str = new String(new char[]{(char)Integer.parseInt(octal, 8)});
            } else if (!raw && hex != null) {
                str = new String(new char[]{(char)Integer.parseInt(hex, 16)});
            } else if (escapedUnicode && unicode16 != null) {
                str = unicode ? new String(new char[]{(char)Integer.parseInt(unicode16, 16)}) : wholeMatch;
            } else if (escapedUnicode && unicode32 != null) {
                String s = wholeMatch;
                if (unicode) {
                    try {
                        s = new String(Character.toChars((int)Long.parseLong(unicode32, 16)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                str = s;
            } else if (raw) {
                str = wholeMatch;
            } else {
                String toReplace = PyStringLiteralDecoder.escapeRegexGroup(escMatcher, EscapeRegexGroup.ESCAPED_SUBSTRING);
                str = escapeMap.get(toReplace);
            }
            if (str != null) {
                TextRange wholeMatchRange = TextRange.create((int)escMatcher.start(), (int)escMatcher.end());
                result2.add((Pair<TextRange, String>)Pair.create((Object)wholeMatchRange.shiftRight(offset), (Object)str));
            }
            index = escMatcher.end();
        }
        range = TextRange.create((int)index, (int)encoded.length());
        TextRange offRange = range.shiftRight(offset);
        result2.add(Pair.create((Object)offRange, (Object)range.substring(encoded)));
        ArrayList<Pair<TextRange, String>> arrayList = result2;
        if (arrayList == null) {
            PyStringLiteralDecoder.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static String escapeRegexGroup(@NotNull Matcher matcher, EscapeRegexGroup group2) {
        if (matcher == null) {
            PyStringLiteralDecoder.$$$reportNull$$$0(6);
        }
        return matcher.group(group2.ordinal());
    }

    private boolean isUnicodeByDefault() {
        if (!LanguageLevel.forElement(this.myNode).isPython2()) {
            return true;
        }
        PsiFile file = this.myNode.getContainingFile();
        if (file instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            return pyFile.hasImportFromFuture(FutureFeature.UNICODE_LITERALS);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyStringLiteralDecoder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoded";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeEscapeMap";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyStringLiteralDecoder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "decodeRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "decodeFragment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "escapeRegexGroup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }

    private static enum EscapeRegexGroup {
        WHOLE_MATCH,
        FSTRING_BRACE,
        ESCAPED_SUBSTRING,
        OCTAL,
        HEXADECIMAL,
        UNICODE_NAMED,
        UNICODE_16BIT,
        UNICODE_32BIT;

    }
}

