/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyAddPropertyForFieldQuickFix
implements LocalQuickFix {
    @IntentionFamilyName
    private final String myName;

    public PyAddPropertyForFieldQuickFix(@NotNull @IntentionFamilyName String name2) {
        if (name2 == null) {
            PyAddPropertyForFieldQuickFix.$$$reportNull$$$0(0);
        }
        this.myName = name2;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            PyAddPropertyForFieldQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PyTargetExpression target;
        PyClass containingClass;
        PsiReference reference;
        PsiElement resolved;
        PsiElement element;
        if (project == null) {
            PyAddPropertyForFieldQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            PyAddPropertyForFieldQuickFix.$$$reportNull$$$0(3);
        }
        if ((element = descriptor2.getPsiElement()) instanceof PyReferenceExpression && (resolved = (reference = element.getReference()).resolve()) instanceof PyTargetExpression && (containingClass = (target = (PyTargetExpression)resolved).getContainingClass()) != null) {
            PyExpression qualifier;
            String name2 = target.getName();
            if (name2 == null) {
                return;
            }
            String propertyName = StringUtil.trimStart((String)name2, (String)"_");
            Map<String, Property> properties = containingClass.getProperties();
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            if (!properties.containsKey(propertyName)) {
                PyFunction property = generator.createProperty(LanguageLevel.forElement((PsiElement)containingClass), propertyName, name2, AccessDirection.READ);
                PyPsiRefactoringUtil.addElementToStatementList(property, containingClass.getStatementList(), false);
            }
            if ((qualifier = ((PyReferenceExpression)element).getQualifier()) != null) {
                String newElementText = qualifier.getText() + "." + propertyName;
                PyExpression newElement = generator.createExpressionFromText(LanguageLevel.forElement((PsiElement)containingClass), newElementText);
                element.replace((PsiElement)newElement);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyAddPropertyForFieldQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyAddPropertyForFieldQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

