/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyProtocolInspection;
import com.jetbrains.python.inspections.PyProtocolInspection$Visitor$checkCompatibility$;
import com.jetbrains.python.inspections.PyProtocolInspection$Visitor$checkMemberCompatibility$;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyProtocolInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyProtocolInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(session)");
        return new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002J.\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/inspections/PyProtocolInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "checkCompatibility", "", "type", "Lcom/jetbrains/python/psi/types/PyClassType;", "superClassTypes", "", "Lcom/jetbrains/python/psi/types/PyClassLikeType;", "checkMemberCompatibility", "protocolElement", "Lcom/jetbrains/python/psi/PyTypedElement;", "subclassElements", "Lcom/jetbrains/python/psi/resolve/RatedResolveResult;", "protocol", "checkNewTypeWithProtocols", "node", "Lcom/jetbrains/python/psi/PyCallExpression;", "checkProtocolBases", "checkRuntimeProtocolInIsInstance", "visitPyCallExpression", "visitPyClass", "Lcom/jetbrains/python/psi/PyClass;", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyProtocolInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyProtocolInspection.kt\ncom/jetbrains/python/inspections/PyProtocolInspection$Visitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n473#2:150\n1295#2:151\n1296#2:154\n1229#2,2:158\n473#2:165\n1295#2,2:166\n1855#3,2:152\n1726#3,3:155\n1747#3,3:160\n288#3,2:163\n*S KotlinDebug\n*F\n+ 1 PyProtocolInspection.kt\ncom/jetbrains/python/inspections/PyProtocolInspection$Visitor\n*L\n53#1:150\n55#1:151\n55#1:154\n90#1:158,2\n139#1:165\n142#1:166,2\n56#1:152,2\n79#1:155,3\n102#1:160,3\n118#1:163,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyClass(node);
            PyType pyType = this.myTypeEvalContext.getType(node);
            PyClassType pyClassType = pyType instanceof PyClassType ? (PyClassType)pyType : null;
            if (pyClassType == null) {
                return;
            }
            PyClassType type2 = pyClassType;
            List<PyClassLikeType> list = type2.getSuperClassTypes(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(list, (String)"type.getSuperClassTypes(myTypeEvalContext)");
            List<PyClassLikeType> superClassTypes = list;
            this.checkCompatibility(type2, superClassTypes);
            this.checkProtocolBases(type2, superClassTypes);
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyCallExpression(node);
            this.checkRuntimeProtocolInIsInstance(node);
            this.checkNewTypeWithProtocols(node);
        }

        private final void checkCompatibility(PyClassType type2, List<? extends PyClassLikeType> superClassTypes) {
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)superClassTypes);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$checkCompatibility$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<PyClassType, Boolean>(this){
                final /* synthetic */ Visitor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PyClassType it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    PyClassLikeType pyClassLikeType = it;
                    TypeEvalContext typeEvalContext = this.this$0.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                    return PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyClassType protocol = (PyClassType)element$iv;
                boolean bl = false;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                Iterable $this$forEach$iv2 = PyProtocolsKt.inspectProtocolSubclass(protocol, type2, typeEvalContext);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Pair it = (Pair)element$iv2;
                    boolean bl2 = false;
                    List subclassElements = (List)it.getSecond();
                    Collection collection = subclassElements;
                    if (collection == null || collection.isEmpty()) continue;
                    this.checkMemberCompatibility((PyTypedElement)it.getFirst(), subclassElements, type2, protocol);
                }
            }
        }

        private final void checkProtocolBases(PyClassType type2, List<? extends PyClassLikeType> superClassTypes) {
            boolean bl;
            block5: {
                PyClassLikeType pyClassLikeType = type2;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (!PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext)) {
                    return;
                }
                Function1 correctBase2 = (Function1)new Function1<PyClassLikeType, Boolean>(this){
                    final /* synthetic */ Visitor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@Nullable PyClassLikeType it) {
                        boolean bl;
                        block5: {
                            block4: {
                                if (it == null) {
                                    bl = true;
                                    return bl;
                                }
                                String classQName = it.getClassQName();
                                if (Intrinsics.areEqual((Object)classQName, (Object)"typing.Protocol") || Intrinsics.areEqual((Object)classQName, (Object)"typing_extensions.Protocol")) break block4;
                                if (!(it instanceof PyClassType)) break block5;
                                TypeEvalContext typeEvalContext = this.this$0.myTypeEvalContext;
                                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                                if (!PyProtocolsKt.isProtocol(it, typeEvalContext)) break block5;
                            }
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                };
                Iterable $this$all$iv = superClassTypes;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        if (((Boolean)correctBase2.invoke(element$iv)).booleanValue()) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                this.registerProblem(type2.getPyClass().getNameIdentifier(), PyPsiBundle.message("INSP.protocol.all.bases.protocol.must.be.protocols", new Object[0]));
            }
        }

        private final void checkRuntimeProtocolInIsInstance(PyCallExpression node) {
            String[] stringArray = new String[]{"isinstance", "issubclass"};
            if (node.isCalleeText(stringArray)) {
                PyType type2;
                Object it;
                Object element$iv;
                Iterator iterator;
                boolean $i$f$any;
                Object $this$any$iv;
                PyExpression[] pyExpressionArray = node.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"node.arguments");
                PyExpression pyExpression = (PyExpression)ArraysKt.getOrNull((Object[])pyExpressionArray, (int)1);
                if (pyExpression == null) {
                    return;
                }
                PyExpression base = pyExpression;
                if (base instanceof PyReferenceExpression) {
                    boolean bl;
                    block11: {
                        List<QualifiedName> list = PyResolveUtil.resolveImportedElementQNameLocally((PyReferenceExpression)base);
                        Intrinsics.checkNotNullExpressionValue(list, (String)"resolveImportedElementQNameLocally(base)");
                        Sequence qNames2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)checkRuntimeProtocolInIsInstance.qNames.1.INSTANCE);
                        $this$any$iv = qNames2;
                        $i$f$any = false;
                        iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            element$iv = iterator.next();
                            it = (String)element$iv;
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual((Object)it, (Object)"typing.Protocol") || Intrinsics.areEqual((Object)it, (Object)"typing_extensions.Protocol"))) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                    if (bl) {
                        this.registerProblem((PsiElement)base, PyPsiBundle.message("INSP.protocol.only.runtime.checkable.protocols.can.be.used.with.instance.class.checks", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                        return;
                    }
                }
                if ((type2 = this.myTypeEvalContext.getType(base)) instanceof PyClassType) {
                    PyClassLikeType pyClassLikeType = (PyClassLikeType)type2;
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext)) {
                        boolean bl;
                        block12: {
                            List<PyKnownDecoratorUtil.KnownDecorator> list = PyKnownDecoratorUtil.getKnownDecorators(((PyClassType)type2).getPyClass(), this.myTypeEvalContext);
                            Intrinsics.checkNotNullExpressionValue(list, (String)"getKnownDecorators(type.\u2026Class, myTypeEvalContext)");
                            $this$any$iv = list;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                iterator = $this$any$iv.iterator();
                                while (iterator.hasNext()) {
                                    element$iv = iterator.next();
                                    it = (PyKnownDecoratorUtil.KnownDecorator)((Object)element$iv);
                                    boolean bl3 = false;
                                    if (!(it == PyKnownDecoratorUtil.KnownDecorator.TYPING_RUNTIME_CHECKABLE || it == PyKnownDecoratorUtil.KnownDecorator.TYPING_RUNTIME_CHECKABLE_EXT || it == PyKnownDecoratorUtil.KnownDecorator.TYPING_RUNTIME || it == PyKnownDecoratorUtil.KnownDecorator.TYPING_RUNTIME_EXT)) continue;
                                    bl = true;
                                    break block12;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) {
                            this.registerProblem((PsiElement)base, PyPsiBundle.message("INSP.protocol.only.runtime.checkable.protocols.can.be.used.with.instance.class.checks", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkNewTypeWithProtocols(PyCallExpression node) {
            block4: {
                PyType type2;
                Object v2;
                block3: {
                    void $this$firstOrNull$iv;
                    PyResolveContext pyResolveContext = PyResolveContext.defaultContext(this.myTypeEvalContext);
                    Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"defaultContext(myTypeEvalContext)");
                    PyResolveContext resolveContext = pyResolveContext;
                    List<PyCallable> list = node.multiResolveCalleeFunction(resolveContext);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"node\n        .multiResol\u2026eFunction(resolveContext)");
                    Iterable iterable = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PyCallable it = (PyCallable)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"typing.NewType")) continue;
                        v2 = element$iv;
                        break block3;
                    }
                    v2 = null;
                }
                PyCallable pyCallable = v2;
                if (pyCallable == null) break block4;
                PyCallable it = pyCallable;
                boolean bl = false;
                PyExpression[] pyExpressionArray = node.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"node.arguments");
                PyExpression base = (PyExpression)ArraysKt.getOrNull((Object[])pyExpressionArray, (int)1);
                if (base != null && (type2 = this.myTypeEvalContext.getType(base)) instanceof PyClassLikeType) {
                    PyClassLikeType pyClassLikeType = (PyClassLikeType)type2;
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (PyProtocolsKt.isProtocol(pyClassLikeType, typeEvalContext)) {
                        this.registerProblem((PsiElement)base, PyPsiBundle.message("INSP.protocol.newtype.cannot.be.used.with.protocol.classes", new Object[0]));
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkMemberCompatibility(PyTypedElement protocolElement, List<? extends RatedResolveResult> subclassElements, PyClassType type2, PyClassType protocol) {
            void $this$forEach$iv;
            Sequence $this$filterIsInstance$iv;
            PyType expectedMemberType = this.myTypeEvalContext.getType(protocolElement);
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)subclassElements), (Function1)checkMemberCompatibility.1.INSTANCE);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$checkMemberCompatibility$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)((Function1)new Function1<PyTypedElement, Boolean>(type2){
                final /* synthetic */ PyClassType $type;
                {
                    this.$type = $type;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PyTypedElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getContainingFile(), (Object)this.$type.getPyClass().getContainingFile());
                }
            })), (Function1)((Function1)new Function1<PyTypedElement, Boolean>(expectedMemberType, this){
                final /* synthetic */ PyType $expectedMemberType;
                final /* synthetic */ Visitor this$0;
                {
                    this.$expectedMemberType = $expectedMemberType;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PyTypedElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return PyTypeChecker.match(this.$expectedMemberType, this.this$0.myTypeEvalContext.getType(it), this.this$0.myTypeEvalContext);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyTypedElement it = (PyTypedElement)element$iv;
                boolean bl = false;
                PsiElement place = it instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)it).getNameIdentifier() : (PsiElement)it;
                Object[] objectArray = new Object[]{it.getName(), protocol.getName()};
                this.registerProblem(place, PyPsiBundle.message("INSP.protocol.element.type.incompatible.with.protocol", objectArray));
            }
        }
    }
}

