/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyAddPropertyForFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.PyMakePublicQuickFix;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.testing.PythonUnitTestDetectorsKt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyProtectedMemberInspection
extends PyInspection {
    public boolean ignoreTestFunctions = true;
    public boolean ignoreAnnotations = false;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyProtectedMemberInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyProtectedMemberInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreTestFunctions", (String)PyPsiBundle.message("INSP.protected.member.ignore.test.functions", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreAnnotations", (String)PyPsiBundle.message("INSP.protected.member.ignore.annotations", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PyProtectedMemberInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyProtectedMemberInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyProtectedMemberInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyImportElement(@NotNull PyImportElement node) {
            PyStatement statement;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (!((statement = node.getContainingImportStatement()) instanceof PyFromImportStatement)) {
                return;
            }
            PyReferenceExpression importReferenceExpression = node.getImportReferenceExpression();
            PyReferenceExpression importSource = ((PyFromImportStatement)statement).getImportSource();
            if (importReferenceExpression != null && importSource != null && !this.isImportFromTheSamePackage(importSource)) {
                this.checkReference(importReferenceExpression, importSource);
            }
        }

        private boolean isImportFromTheSamePackage(@NotNull PyReferenceExpression importSource) {
            PsiDirectory currentFileDirectory;
            if (importSource == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((currentFileDirectory = importSource.getContainingFile().getContainingDirectory()) != null && PyUtil.isPackage(currentFileDirectory, true, (PsiElement)importSource)) {
                PyResolveContext resolveContext = PyResolveContext.defaultContext(this.myTypeEvalContext);
                return StreamEx.of((Object[])importSource.getReference(resolveContext).multiResolve(false)).map(ResolveResult::getElement).select(PyFile.class).map(PsiFile::getContainingDirectory).nonNull().map(PsiDirectory::getVirtualFile).anyMatch(importedSourceDir -> VfsUtilCore.isAncestor((VirtualFile)importedSourceDir, (VirtualFile)currentFileDirectory.getVirtualFile(), (boolean)false));
            }
            return false;
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            PyExpression qualifier = node.getQualifier();
            if (PyProtectedMemberInspection.this.ignoreAnnotations && PsiTreeUtil.getParentOfType((PsiElement)node, PyAnnotation.class) != null) {
                return;
            }
            if (qualifier == null || ArrayUtil.contains((String)qualifier.getText(), (String[])new String[]{"self", "cls"})) {
                return;
            }
            if (this.isImportFromTheSamePackage(node)) {
                return;
            }
            this.checkReference(node, qualifier);
        }

        private void checkReference(@NotNull PyReferenceExpression node, @NotNull PyExpression qualifier) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (qualifier == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            String name2 = node.getName();
            ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
            LocalQuickFix renameElementQuickFix = PythonUiService.getInstance().createPyRenameElementQuickFix((PsiElement)node);
            if (renameElementQuickFix != null) {
                quickFixes.add(renameElementQuickFix);
            }
            if (name2 != null && name2.startsWith("_") && !name2.startsWith("__") && !name2.endsWith("__")) {
                PyType type2;
                PsiPolyVariantReference reference = node.getReference(this.getResolveContext());
                for (PyInspectionExtension inspectionExtension : (PyInspectionExtension[])PyInspectionExtension.EP_NAME.getExtensions()) {
                    if (!inspectionExtension.ignoreProtectedSymbol(node, this.myTypeEvalContext)) continue;
                    return;
                }
                PsiElement resolvedExpression = reference.resolve();
                PyClass resolvedClass = this.getNotPyiClassOwner(resolvedExpression);
                if (resolvedExpression instanceof PyTargetExpression) {
                    String newName = StringUtil.trimLeading((String)name2, (char)'_');
                    if (resolvedClass != null) {
                        Set<String> usedNames;
                        String qFixName = resolvedClass.getProperties().containsKey(newName) ? PyPsiBundle.message("QFIX.use.property", new Object[0]) : PyPsiBundle.message("QFIX.add.property", new Object[0]);
                        quickFixes.add(new PyAddPropertyForFieldQuickFix(qFixName));
                        PyClassType classType = PyUtil.as(this.myTypeEvalContext.getType(resolvedClass), PyClassType.class);
                        if (classType != null && !(usedNames = classType.getMemberNames(true, this.myTypeEvalContext)).contains(newName)) {
                            quickFixes.add(new PyMakePublicQuickFix());
                        }
                    }
                }
                if (PyProtectedMemberInspection.this.ignoreTestFunctions) {
                    for (PsiElement item = node.getParent(); item != null && !(item instanceof PsiFileSystemItem); item = item.getParent()) {
                        if (!PythonUnitTestDetectorsKt.isTestElement(item, this.myTypeEvalContext)) continue;
                        return;
                    }
                }
                if (resolvedClass != null) {
                    PyClass parentClass = this.getClassOwner((PsiElement)node);
                    while (parentClass != null) {
                        if (parentClass.isSubclass(resolvedClass, this.myTypeEvalContext)) {
                            return;
                        }
                        parentClass = this.getClassOwner((PsiElement)parentClass);
                    }
                }
                @InspectionMessage String message = (type2 = this.myTypeEvalContext.getType(qualifier)) instanceof PyModuleType ? PyPsiBundle.message("INSP.protected.member.access.to.protected.member.of.module", name2) : PyPsiBundle.message("INSP.protected.member.access.to.protected.member.of.class", name2);
                this.registerProblem((PsiElement)node, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        @Nullable
        private PyClass getNotPyiClassOwner(@Nullable PsiElement element) {
            PyClass owner = this.getClassOwner(element);
            return owner == null ? null : PyiUtil.getOriginalElementOrLeaveAsIs(owner, PyClass.class);
        }

        @Nullable
        private PyClass getClassOwner(@Nullable PsiElement element) {
            ScopeOwner owner = ScopeUtil.getScopeOwner(element);
            while (owner != null) {
                if (owner instanceof PyClass) {
                    return (PyClass)owner;
                }
                owner = ScopeUtil.getScopeOwner((PsiElement)owner);
            }
            return null;
        }

        @Override
        public void visitPyFromImportStatement(@NotNull PyFromImportStatement node) {
            PyReferenceExpression source;
            if (node == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if ((source = node.getImportSource()) == null) {
                return;
            }
            Set<String> dunderAlls = this.collectDunderAlls(source);
            if (dunderAlls == null) {
                return;
            }
            ((StreamEx)StreamEx.of((Object[])node.getImportElements()).map(PyImportElement::getImportReferenceExpression).nonNull().filter(referenceExpression -> !dunderAlls.contains(referenceExpression.getName()) && !this.resolvesToFileSystemItem((PyReferenceExpression)referenceExpression))).forEach(referenceExpression -> {
                String message = PyPsiBundle.message("INSP.protected.member.name.not.declared.in.all", referenceExpression.getName());
                this.registerProblem((PsiElement)referenceExpression, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            });
        }

        @Nullable
        private Set<String> collectDunderAlls(@NotNull PyReferenceExpression source) {
            PyResolveContext resolveContext;
            List resolvedDunderAlls;
            if (source == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if ((resolvedDunderAlls = StreamEx.of((Object[])source.getReference(resolveContext = PyResolveContext.defaultContext(this.myTypeEvalContext)).multiResolve(false)).map(ResolveResult::getElement).select(PyFile.class).map(PyFile::getDunderAll).toList()).isEmpty()) {
                return null;
            }
            HashSet<String> result2 = new HashSet<String>();
            for (List dunderAll : resolvedDunderAlls) {
                if (dunderAll == null) {
                    return null;
                }
                result2.addAll(dunderAll);
            }
            return result2;
        }

        private boolean resolvesToFileSystemItem(@NotNull PyReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            PyResolveContext resolveContext = PyResolveContext.defaultContext(this.myTypeEvalContext);
            return ContainerUtil.exists((Object[])referenceExpression.getReference(resolveContext).multiResolve(false), result2 -> result2.getElement() instanceof PsiFileSystemItem);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importSource";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyProtectedMemberInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyImportElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isImportFromTheSamePackage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyReferenceExpression";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkReference";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFromImportStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectDunderAlls";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolvesToFileSystemItem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

