/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ListCreationQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyListCreationInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyListCreationInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyListCreationInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    @NotNull
    public static List<PyExpressionStatement> collectSubsequentListAppendCalls(@NotNull PyAssignmentStatement assignment) {
        String funcName;
        PyExpression qualifier;
        PyCallExpression callExpression;
        PyExpression callee;
        PyExpression statement;
        if (assignment == null) {
            PyListCreationInspection.$$$reportNull$$$0(2);
        }
        ArrayList<PyExpressionStatement> result2 = new ArrayList<PyExpressionStatement>();
        PyExpression[] targets = assignment.getTargets();
        assert (targets.length == 1);
        PyExpression target = targets[0];
        String name2 = target.getName();
        assert (name2 != null);
        PyStatement expressionStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)assignment, PyStatement.class);
        while (expressionStatement instanceof PyExpressionStatement && (statement = ((PyExpressionStatement)expressionStatement).getExpression()) instanceof PyCallExpression && (callee = (callExpression = (PyCallExpression)statement).getCallee()) instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)callee).getQualifier()) != null && name2.equals(qualifier.getText()) && "append".equals(funcName = ((PyQualifiedExpression)callee).getReferencedName())) {
            PyArgumentList argList = callExpression.getArgumentList();
            if (argList != null) {
                if (ContainerUtil.exists((Object[])argList.getArguments(), argument -> argument.getText().equals(name2))) break;
                result2.add((PyExpressionStatement)expressionStatement);
            }
            expressionStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)expressionStatement, PyStatement.class);
        }
        ArrayList<PyExpressionStatement> arrayList = result2;
        if (arrayList == null) {
            PyListCreationInspection.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyListCreationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyListCreationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSubsequentListAppendCalls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSubsequentListAppendCalls";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (!(node.getAssignedValue() instanceof PyListLiteralExpression)) {
                return;
            }
            PyExpression[] targets = node.getTargets();
            if (targets.length != 1) {
                return;
            }
            PyExpression target = targets[0];
            String name2 = target.getName();
            if (name2 == null) {
                return;
            }
            List<PyExpressionStatement> appendCalls = PyListCreationInspection.collectSubsequentListAppendCalls(node);
            if (!appendCalls.isEmpty()) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.list.creation.this.list.creation.could.be.rewritten.as.list.literal", new Object[0]), new ListCreationQuickFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyListCreationInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAssignmentStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

