/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDeprecationInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyDeprecationInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyDeprecationInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyDeprecationInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            PyExpression exceptClass;
            PyExceptPart exceptPart;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((exceptPart = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyExceptPart.class)) != null && (exceptClass = exceptPart.getExceptClass()) != null && "ImportError".equals(exceptClass.getText())) {
                return;
            }
            PyElement resolveResult = this.resolve(node);
            PyFromImportStatement importStatement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyFromImportStatement.class);
            if (importStatement != null) {
                PsiFileSystemItem element = importStatement.resolveImportSource();
                if (resolveResult != null && element != resolveResult.getContainingFile()) {
                    return;
                }
            }
            String deprecationMessage = null;
            if (resolveResult instanceof PyFunction) {
                deprecationMessage = ((PyFunction)resolveResult).getDeprecationMessage();
            } else if (resolveResult instanceof PyFile) {
                deprecationMessage = ((PyFile)resolveResult).getDeprecationMessage();
            }
            if (deprecationMessage != null) {
                ASTNode nameElement = node.getNameElement();
                this.registerProblem((PsiElement)(nameElement == null ? node : nameElement.getPsi()), deprecationMessage, ProblemHighlightType.LIKE_DEPRECATED);
            }
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitPyFunction(node);
            PyDecoratorList decoratorList = node.getDecoratorList();
            if (!LanguageLevel.forElement(node).isPython2() && decoratorList != null) {
                for (PyDecorator decorator : decoratorList.getDecorators()) {
                    for (PyKnownDecoratorUtil.KnownDecorator knownDecorator : PyKnownDecoratorUtil.asKnownDecorators(decorator, this.myTypeEvalContext)) {
                        PyKnownDecoratorUtil.KnownDecorator builtin;
                        PyKnownDecoratorUtil.KnownDecorator deprecated;
                        if (knownDecorator == PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTPROPERTY) {
                            deprecated = PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTPROPERTY;
                            builtin = PyKnownDecoratorUtil.KnownDecorator.PROPERTY;
                        } else if (knownDecorator == PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTCLASSMETHOD) {
                            deprecated = PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTCLASSMETHOD;
                            builtin = PyKnownDecoratorUtil.KnownDecorator.CLASSMETHOD;
                        } else {
                            if (knownDecorator != PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTSTATICMETHOD) continue;
                            deprecated = PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTSTATICMETHOD;
                            builtin = PyKnownDecoratorUtil.KnownDecorator.STATICMETHOD;
                        }
                        PyKnownDecoratorUtil.KnownDecorator abcAbsMethod = PyKnownDecoratorUtil.KnownDecorator.ABC_ABSTRACTMETHOD;
                        String message = PyPsiBundle.message("INSP.deprecation.abc.decorator.deprecated.use.alternative", deprecated.getQualifiedName(), builtin.getQualifiedName(), abcAbsMethod.getQualifiedName());
                        this.registerProblem((PsiElement)decorator, message, ProblemHighlightType.LIKE_DEPRECATED);
                    }
                }
            }
        }

        @Nullable
        private PyElement resolve(@NotNull PyReferenceExpression node) {
            PyElement resolve;
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            return (resolve = PyUtil.as(node.getReference(this.getResolveContext()).resolve(), PyElement.class)) == null ? null : PyiUtil.getOriginalElementOrLeaveAsIs(resolve, PyElement.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyDeprecationInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolve";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

