/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PyDocSignaturesHighlighterKt;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyDynamicallyEvaluatedType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNamedTupleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeModelBuilder {
    private final Map<PyType, TypeModel> myVisited = Maps.newHashMap();
    private final TypeEvalContext myContext;

    PyTypeModelBuilder(TypeEvalContext context) {
        this.myContext = context;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public TypeModel build(@Nullable PyType type2, boolean allowUnions) {
        void var4_25;
        void var4_23;
        block17: {
            block23: {
                Collection<PyType> unionMembers;
                PyUnionType unionType;
                block25: {
                    Ref<PyType> optionalType;
                    block24: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            TypeModel evaluated = this.myVisited.get(type2);
                                            if (evaluated != null) {
                                                return evaluated;
                                            }
                                            if (this.myVisited.containsKey(type2)) {
                                                return NamedType.nameOrAny(type2);
                                            }
                                            this.myVisited.put(type2, null);
                                            Object var4_4 = null;
                                            if (!(type2 instanceof PyTypedDictType)) break block18;
                                            PyTypedDictType typedDictType = (PyTypedDictType)type2;
                                            if (typedDictType.isInferred()) {
                                                return this.build(new PyCollectionTypeImpl(typedDictType.getPyClass(), false, typedDictType.getElementTypes()), allowUnions);
                                            }
                                            NamedType namedType = NamedType.nameOrAny(type2);
                                            break block17;
                                        }
                                        if (!(type2 instanceof PyInstantiableType) || !((PyInstantiableType)type2).isDefinition()) break block19;
                                        Object instanceType = ((PyInstantiableType)type2).toInstance();
                                        if (type2 instanceof PyClassType && instanceType.equals(PyBuiltinCache.getInstance((PsiElement)((PyClassType)type2).getPyClass()).getTypeType())) {
                                            NamedType namedType = NamedType.nameOrAny(type2);
                                            break block17;
                                        } else {
                                            ClassObjectType classObjectType = new ClassObjectType(this.build((PyType)instanceType, allowUnions));
                                        }
                                        break block17;
                                    }
                                    if (!(type2 instanceof PyNamedTupleType)) break block20;
                                    NamedType namedType = NamedType.nameOrAny(type2);
                                    break block17;
                                }
                                if (!(type2 instanceof PyTupleType)) break block21;
                                PyTupleType tupleType = (PyTupleType)type2;
                                List<PyType> elementTypes = tupleType.isHomogeneous() ? Collections.singletonList(tupleType.getIteratedItemType()) : tupleType.getElementTypes();
                                boolean useTypingAlias = PyiUtil.getOriginalLanguageLevel(tupleType.getPyClass()).isOlderThan(LanguageLevel.PYTHON39);
                                List elementModels = ContainerUtil.map(elementTypes, elementType -> this.build((PyType)elementType, true));
                                TupleType tupleType2 = new TupleType(elementModels, tupleType.isHomogeneous(), useTypingAlias);
                                break block17;
                            }
                            if (!(type2 instanceof PyCollectionType)) break block22;
                            PyCollectionType asCollection = (PyCollectionType)type2;
                            ArrayList<TypeModel> elementModels = new ArrayList<TypeModel>();
                            for (PyType elementType2 : asCollection.getElementTypes()) {
                                elementModels.add(this.build(elementType2, true));
                            }
                            if (!elementModels.isEmpty()) {
                                TypeModel collectionType = this.build(new PyClassTypeImpl(asCollection.getPyClass(), asCollection.isDefinition()), false);
                                boolean useTypingAlias = PyiUtil.getOriginalLanguageLevel(asCollection.getPyClass()).isOlderThan(LanguageLevel.PYTHON39);
                                CollectionOf collectionOf = new CollectionOf(collectionType, elementModels, useTypingAlias);
                            }
                            break block17;
                        }
                        if (!(type2 instanceof PyUnionType)) break block23;
                        unionType = (PyUnionType)type2;
                        if (!allowUnions) break block23;
                        unionMembers = unionType.getMembers();
                        Pair<List<PyLiteralType>, List<PyType>> literalsAndOthers = PyTypeModelBuilder.extractLiterals(unionType);
                        optionalType = PyTypeModelBuilder.getOptionalType(unionType);
                        if (literalsAndOthers == null) break block24;
                        OneOfLiterals oneOfLiterals = new OneOfLiterals((List)literalsAndOthers.first);
                        if (!((List)literalsAndOthers.second).isEmpty()) {
                            List otherTypeModels = ContainerUtil.map((Collection)((Collection)literalsAndOthers.second), t -> this.build((PyType)t, false));
                            OneOf oneOf = new OneOf(ContainerUtil.prepend((List)otherTypeModels, (Object[])new TypeModel[]{oneOfLiterals}), PyTypingTypeProvider.isBitwiseOrUnionAvailable(this.myContext));
                            break block17;
                        } else {
                            OneOfLiterals oneOfLiterals2 = oneOfLiterals;
                        }
                        break block17;
                    }
                    if (optionalType == null) break block25;
                    OptionalType optionalType2 = new OptionalType(this.build((PyType)optionalType.get(), true), PyTypingTypeProvider.isBitwiseOrUnionAvailable(this.myContext));
                    break block17;
                }
                if (type2 instanceof PyDynamicallyEvaluatedType || PyTypeChecker.isUnknown(type2, false, this.myContext)) {
                    UnknownType unknownType = new UnknownType(this.build(unionType.excludeNull(), true), PyTypingTypeProvider.isBitwiseOrUnionAvailable(this.myContext));
                    break block17;
                } else if (ContainerUtil.all(unionMembers, t -> t instanceof PyClassType && ((PyClassType)t).isDefinition())) {
                    List instanceTypes = ContainerUtil.map(unionMembers, t -> this.build((PyType)((PyClassType)t).toInstance(), allowUnions));
                    ClassObjectType classObjectType = new ClassObjectType(new OneOf(instanceTypes, PyTypingTypeProvider.isBitwiseOrUnionAvailable(this.myContext)));
                    break block17;
                } else {
                    OneOf oneOf = new OneOf(Collections2.transform(unionMembers, t -> this.build((PyType)t, false)), PyTypingTypeProvider.isBitwiseOrUnionAvailable(this.myContext));
                }
                break block17;
            }
            if (type2 instanceof PyCallableType && !(type2 instanceof PyClassLikeType)) {
                TypeModel typeModel = this.buildCallable((PyCallableType)type2);
            } else if (type2 instanceof PyGenericType) {
                GenericType genericType = new GenericType(type2.getName());
            }
        }
        if (var4_23 == null) {
            NamedType namedType = NamedType.nameOrAny(type2);
        }
        this.myVisited.put(type2, (TypeModel)var4_25);
        return var4_25;
    }

    @Nullable
    private static Ref<PyType> getOptionalType(@NotNull PyUnionType type2) {
        Collection<PyType> members2;
        if (type2 == null) {
            PyTypeModelBuilder.$$$reportNull$$$0(0);
        }
        if ((members2 = type2.getMembers()).size() == 2) {
            boolean foundNone = false;
            PyType optional = null;
            for (PyType member : members2) {
                if (PyNoneType.INSTANCE.equals(member)) {
                    foundNone = true;
                    continue;
                }
                if (member == null) continue;
                optional = member;
            }
            if (foundNone) {
                return Ref.create(optional);
            }
        }
        return null;
    }

    private static @Nullable Pair<@NotNull List<PyLiteralType>, @NotNull List<PyType>> extractLiterals(@NotNull PyUnionType type2) {
        Collection<PyType> members2;
        List literalTypes;
        if (type2 == null) {
            PyTypeModelBuilder.$$$reportNull$$$0(1);
        }
        if ((literalTypes = ContainerUtil.filterIsInstance(members2 = type2.getMembers(), PyLiteralType.class)).size() < 2) {
            return null;
        }
        List otherTypes = ContainerUtil.filter(members2, m -> !(m instanceof PyLiteralType));
        return Pair.create((Object)literalTypes, (Object)otherTypes);
    }

    private TypeModel buildCallable(@NotNull PyCallableType type2) {
        if (type2 == null) {
            PyTypeModelBuilder.$$$reportNull$$$0(2);
        }
        ArrayList<TypeModel> parameterModels = null;
        List<PyCallableParameter> parameters = type2.getParameters(this.myContext);
        if (parameters != null) {
            parameterModels = new ArrayList<TypeModel>();
            for (PyCallableParameter parameter : parameters) {
                PyType paramType = parameter.getType(this.myContext);
                if (paramType instanceof PyParamSpecType || paramType instanceof PyConcatenateType) {
                    parameterModels.add(new ParamType(null, this.build(parameter.getType(this.myContext), true)));
                    continue;
                }
                parameterModels.add(new ParamType(parameter.getName(), this.build(parameter.getType(this.myContext), true)));
            }
        }
        PyType ret = type2.getReturnType(this.myContext);
        TypeModel returnType = this.build(ret, true);
        return new FunctionType(returnType, parameterModels);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "type";
        objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionalType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractLiterals";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildCallable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static abstract class TypeModel {
        TypeModel() {
        }

        abstract void accept(@NotNull TypeVisitor var1);

        @NotNull
        public String asString() {
            TypeToStringVisitor visitor2 = new TypeToStringVisitor();
            this.accept(visitor2);
            String string = visitor2.getString();
            if (string == null) {
                TypeModel.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void toBodyWithLinks(@NotNull HtmlBuilder body, @NotNull PsiElement anchor) {
            if (body == null) {
                TypeModel.$$$reportNull$$$0(1);
            }
            if (anchor == null) {
                TypeModel.$$$reportNull$$$0(2);
            }
            TypeToBodyWithLinksVisitor visitor2 = new TypeToBodyWithLinksVisitor(body, anchor);
            this.accept(visitor2);
        }

        @NotNull
        public String asDescription() {
            TypeToDescriptionVisitor visitor2 = new TypeToDescriptionVisitor();
            this.accept(visitor2);
            String string = visitor2.getDescription();
            if (string == null) {
                TypeModel.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String asPep484TypeHint() {
            TypeToPep484TypeHintVisitor visitor2 = new TypeToPep484TypeHintVisitor();
            this.accept(visitor2);
            String string = visitor2.getString();
            if (string == null) {
                TypeModel.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asString";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asPep484TypeHint";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "toBodyWithLinks";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static final class NamedType
    extends TypeModel {
        @NotNull
        private static final NamedType ANY = new NamedType("Any");
        @Nullable
        @NlsSafe
        private final String name;

        private NamedType(@Nullable String name2) {
            this.name = name2;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                NamedType.$$$reportNull$$$0(0);
            }
            visitor2.name(this.name);
        }

        @NotNull
        private static NamedType nameOrAny(@Nullable PyType type2) {
            return type2 == null ? ANY : new NamedType(type2.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$NamedType", "accept"));
        }
    }

    static class ClassObjectType
    extends TypeModel {
        private final TypeModel classType;

        ClassObjectType(TypeModel classType) {
            this.classType = classType;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                ClassObjectType.$$$reportNull$$$0(0);
            }
            visitor2.classObject(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$ClassObjectType", "accept"));
        }
    }

    static class TupleType
    extends TypeModel {
        private final List<TypeModel> members;
        private final boolean homogeneous;
        private final boolean useTypingAlias;

        TupleType(List<TypeModel> members2, boolean homogeneous, boolean useTypingAlias) {
            this.members = members2;
            this.homogeneous = homogeneous;
            this.useTypingAlias = useTypingAlias;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                TupleType.$$$reportNull$$$0(0);
            }
            visitor2.tuple(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$TupleType", "accept"));
        }
    }

    private static final class CollectionOf
    extends TypeModel {
        private final TypeModel collectionType;
        private final List<TypeModel> elementTypes;
        private final boolean useTypingAlias;

        private CollectionOf(TypeModel collectionType, List<TypeModel> elementTypes, boolean useTypingAlias) {
            this.collectionType = collectionType;
            this.elementTypes = elementTypes;
            this.useTypingAlias = useTypingAlias;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                CollectionOf.$$$reportNull$$$0(0);
            }
            visitor2.collectionOf(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$CollectionOf", "accept"));
        }
    }

    private static final class OneOfLiterals
    extends TypeModel {
        @NotNull
        private final List<PyLiteralType> literals;

        private OneOfLiterals(@NotNull List<PyLiteralType> literals) {
            if (literals == null) {
                OneOfLiterals.$$$reportNull$$$0(0);
            }
            this.literals = literals;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                OneOfLiterals.$$$reportNull$$$0(1);
            }
            visitor2.oneOfLiterals(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literals";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder$OneOfLiterals";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class OneOf
    extends TypeModel {
        private final Collection<TypeModel> oneOfTypes;
        private final boolean bitwiseOrUnionAllowed;

        private OneOf(Collection<TypeModel> oneOfTypes, boolean bitwiseOrUnionAllowed) {
            this.oneOfTypes = oneOfTypes;
            this.bitwiseOrUnionAllowed = bitwiseOrUnionAllowed;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                OneOf.$$$reportNull$$$0(0);
            }
            visitor2.oneOf(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$OneOf", "accept"));
        }
    }

    static final class OptionalType
    extends TypeModel {
        private final TypeModel type;
        private final boolean bitwiseOrUnionAllowed;

        private OptionalType(TypeModel type2, boolean bitwiseOrUnionAllowed) {
            this.type = type2;
            this.bitwiseOrUnionAllowed = bitwiseOrUnionAllowed;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                OptionalType.$$$reportNull$$$0(0);
            }
            visitor2.optional(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$OptionalType", "accept"));
        }
    }

    static final class UnknownType
    extends TypeModel {
        private final TypeModel type;
        private final boolean bitwiseOrUnionAllowed;

        private UnknownType(TypeModel type2, boolean bitwiseOrUnionAllowed) {
            this.type = type2;
            this.bitwiseOrUnionAllowed = bitwiseOrUnionAllowed;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                UnknownType.$$$reportNull$$$0(0);
            }
            visitor2.unknown(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$UnknownType", "accept"));
        }
    }

    static class GenericType
    extends TypeModel {
        @NlsSafe
        private final String name;

        GenericType(@Nullable String name2) {
            this.name = name2;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                GenericType.$$$reportNull$$$0(0);
            }
            visitor2.genericType(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$GenericType", "accept"));
        }
    }

    static final class ParamType
    extends TypeModel {
        @Nullable
        @NlsSafe
        private final String name;
        @Nullable
        private final TypeModel type;

        private ParamType(@Nullable String name2, @Nullable TypeModel type2) {
            this.name = name2;
            this.type = type2;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                ParamType.$$$reportNull$$$0(0);
            }
            visitor2.param(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$ParamType", "accept"));
        }
    }

    static final class FunctionType
    extends TypeModel {
        @NotNull
        private final TypeModel returnType;
        @Nullable
        private final Collection<TypeModel> parameters;

        private FunctionType(@Nullable TypeModel returnType, @Nullable Collection<TypeModel> parameters) {
            this.returnType = returnType != null ? returnType : NamedType.ANY;
            this.parameters = parameters;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                FunctionType.$$$reportNull$$$0(0);
            }
            visitor2.function(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$FunctionType", "accept"));
        }
    }

    private static abstract class TypeNameVisitor
    implements TypeVisitor {
        private int myDepth = 0;
        private static final int MAX_DEPTH = 6;
        private boolean switchBuiltinToTyping = false;
        protected HtmlBuilder myBody = new HtmlBuilder();

        private TypeNameVisitor() {
        }

        @Override
        public void oneOf(OneOf oneOf) {
            ++this.myDepth;
            if (this.maxDepthExceeded()) {
                this.add(this.styled("...", PyHighlighter.PY_DOT));
                return;
            }
            if (oneOf.bitwiseOrUnionAllowed) {
                this.processList(oneOf.oneOfTypes, " | ");
            } else {
                this.add(this.escaped("Union"));
                this.add(this.styled("[", PyHighlighter.PY_BRACKETS));
                this.processList(oneOf.oneOfTypes);
                this.add(this.styled("]", PyHighlighter.PY_BRACKETS));
            }
            --this.myDepth;
        }

        protected void processList(@NotNull Collection<TypeModel> list) {
            if (list == null) {
                TypeNameVisitor.$$$reportNull$$$0(0);
            }
            this.processList(list, ", ");
        }

        protected void processList(@NotNull Collection<TypeModel> list, @NotNull @Nls String separator) {
            if (list == null) {
                TypeNameVisitor.$$$reportNull$$$0(1);
            }
            if (separator == null) {
                TypeNameVisitor.$$$reportNull$$$0(2);
            }
            boolean first = true;
            for (TypeModel t : list) {
                if (!first) {
                    if (separator.equals(", ")) {
                        this.add(this.styled(separator, PyHighlighter.PY_COMMA));
                    } else if (separator.equals(" | ")) {
                        this.add(this.styled(separator, PyHighlighter.PY_OPERATION_SIGN));
                    } else {
                        this.add(this.escaped(separator));
                    }
                } else {
                    first = false;
                }
                t.accept(this);
            }
        }

        protected void add(@NotNull HtmlChunk chunk) {
            if (chunk == null) {
                TypeNameVisitor.$$$reportNull$$$0(3);
            }
            this.myBody.append(chunk);
        }

        @NotNull
        protected abstract HtmlChunk styled(@Nls String var1, @NotNull TextAttributesKey var2);

        @NotNull
        protected abstract HtmlChunk escaped(@Nls String var1);

        @NotNull
        protected abstract HtmlChunk className(@Nls String var1);

        @NotNull
        protected abstract HtmlChunk styledExpression(@Nls String var1, @NotNull PyExpression var2);

        @Override
        public void collectionOf(CollectionOf collectionOf) {
            ++this.myDepth;
            if (this.maxDepthExceeded()) {
                this.add(this.styled("...", PyHighlighter.PY_DOT));
                return;
            }
            boolean allTypeParamsAreAny = ContainerUtil.and(collectionOf.elementTypes, t -> t == NamedType.ANY);
            if (allTypeParamsAreAny) {
                collectionOf.collectionType.accept(this);
            } else {
                this.typingGenericFormat(collectionOf);
            }
            --this.myDepth;
        }

        protected void typingGenericFormat(CollectionOf collectionOf) {
            boolean prevSwitchBuiltinToTyping = this.switchBuiltinToTyping;
            this.switchBuiltinToTyping = collectionOf.useTypingAlias;
            collectionOf.collectionType.accept(this);
            this.switchBuiltinToTyping = prevSwitchBuiltinToTyping;
            if (!collectionOf.elementTypes.isEmpty()) {
                this.add(this.styled("[", PyHighlighter.PY_BRACKETS));
                this.processList(collectionOf.elementTypes);
                this.add(this.styled("]", PyHighlighter.PY_BRACKETS));
            }
        }

        @Override
        public void name(@NlsSafe String name2) {
            this.add(this.className(this.switchBuiltinToTyping ? (String)PyTypingTypeProvider.TYPING_COLLECTION_CLASSES.getOrDefault((Object)name2, (Object)name2) : name2));
        }

        @Override
        public void function(FunctionType function) {
            ++this.myDepth;
            if (this.maxDepthExceeded()) {
                this.add(this.styled("...", PyHighlighter.PY_DOT));
                return;
            }
            this.add(this.styled("(", PyHighlighter.PY_PARENTHS));
            Collection<TypeModel> parameters = function.parameters;
            if (parameters != null) {
                this.processList(parameters);
            } else {
                this.add(this.styled("...", PyHighlighter.PY_DOT));
            }
            this.add(this.styled(")", PyHighlighter.PY_PARENTHS));
            this.add(this.escaped(" -> "));
            function.returnType.accept(this);
            --this.myDepth;
        }

        protected boolean maxDepthExceeded() {
            return this.myDepth > 6;
        }

        @Override
        public void param(ParamType param) {
            ++this.myDepth;
            if (this.maxDepthExceeded()) {
                this.add(this.styled("...", PyHighlighter.PY_DOT));
                return;
            }
            if (param.name != null) {
                this.add(this.styled(param.name, PyHighlighter.PY_PARAMETER));
            }
            if (param.type != null) {
                if (param.name != null) {
                    this.add(this.styled(": ", PyHighlighter.PY_OPERATION_SIGN));
                }
                param.type.accept(this);
            }
            --this.myDepth;
        }

        @Override
        public void unknown(UnknownType type2) {
            type2.type.accept(this);
        }

        @Override
        public void optional(OptionalType type2) {
            if (type2.bitwiseOrUnionAllowed) {
                type2.type.accept(this);
                this.add(this.styled(" | ", PyHighlighter.PY_OPERATION_SIGN));
                this.add(this.styled("None", PyHighlighter.PY_KEYWORD));
            } else {
                this.add(this.escaped("Optional"));
                this.add(this.styled("[", PyHighlighter.PY_BRACKETS));
                type2.type.accept(this);
                this.add(this.styled("]", PyHighlighter.PY_BRACKETS));
            }
        }

        @Override
        public void tuple(TupleType type2) {
            if (type2.useTypingAlias) {
                this.add(this.escaped("Tuple"));
            } else {
                this.add(this.styled("tuple", PyHighlighter.PY_BUILTIN_NAME));
            }
            if (!type2.members.isEmpty()) {
                this.add(this.styled("[", PyHighlighter.PY_BRACKETS));
                this.processList(type2.members);
                if (type2.homogeneous) {
                    this.add(this.styled(", ", PyHighlighter.PY_COMMA));
                    this.add(this.styled("...", PyHighlighter.PY_DOT));
                }
                this.add(this.styled("]", PyHighlighter.PY_BRACKETS));
            }
        }

        @Override
        public void classObject(ClassObjectType type2) {
            this.add(this.escaped("Type"));
            this.add(this.styled("[", PyHighlighter.PY_BRACKETS));
            type2.classType.accept(this);
            this.add(this.styled("]", PyHighlighter.PY_BRACKETS));
        }

        @Override
        public void genericType(GenericType type2) {
            if (type2.name != null) {
                this.add(this.escaped(type2.name));
            }
        }

        @Override
        public void oneOfLiterals(OneOfLiterals literals) {
            this.add(new HtmlBuilder().append(this.escaped("Literal")).append(this.styled("[", PyHighlighter.PY_BRACKETS)).append((HtmlChunk)StreamEx.of(literals.literals).map(PyLiteralType::getExpression).map(expr -> this.styledExpression(expr.getText(), (PyExpression)expr)).collect(HtmlChunk.toFragment((HtmlChunk)this.styled(", ", PyHighlighter.PY_COMMA)))).append(this.styled("]", PyHighlighter.PY_BRACKETS)).toFragment());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunk";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeNameVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TypeToDescriptionVisitor
    extends TypeNameVisitor {
        private TypeToDescriptionVisitor() {
        }

        @Override
        @NotNull
        protected HtmlChunk styled(@Nls String text, @NotNull TextAttributesKey style) {
            if (style == null) {
                TypeToDescriptionVisitor.$$$reportNull$$$0(0);
            }
            HtmlChunk htmlChunk = HtmlChunk.raw((String)text);
            if (htmlChunk == null) {
                TypeToDescriptionVisitor.$$$reportNull$$$0(1);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk escaped(@Nls String text) {
            HtmlChunk htmlChunk = HtmlChunk.raw((String)text);
            if (htmlChunk == null) {
                TypeToDescriptionVisitor.$$$reportNull$$$0(2);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk className(@Nls String name2) {
            HtmlChunk htmlChunk = this.escaped(name2);
            if (htmlChunk == null) {
                TypeToDescriptionVisitor.$$$reportNull$$$0(3);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk styledExpression(@Nls String expressionText, @NotNull PyExpression expression) {
            if (expression == null) {
                TypeToDescriptionVisitor.$$$reportNull$$$0(4);
            }
            HtmlChunk htmlChunk = HtmlChunk.raw((String)expressionText);
            if (htmlChunk == null) {
                TypeToDescriptionVisitor.$$$reportNull$$$0(5);
            }
            return htmlChunk;
        }

        @NotNull
        public String getDescription() {
            String string = this.myBody.toString();
            if (string == null) {
                TypeToDescriptionVisitor.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeToDescriptionVisitor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeToDescriptionVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "styled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escaped";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "className";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "styledExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "styled";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "styledExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class TypeToBodyWithLinksVisitor
    extends TypeNameVisitor {
        private final PsiElement myAnchor;

        TypeToBodyWithLinksVisitor(HtmlBuilder body, PsiElement anchor) {
            this.myBody = body;
            this.myAnchor = anchor;
        }

        @Override
        @NotNull
        protected HtmlChunk styled(@Nls String text, @NotNull TextAttributesKey style) {
            if (style == null) {
                TypeToBodyWithLinksVisitor.$$$reportNull$$$0(0);
            }
            HtmlChunk htmlChunk = PyDocSignaturesHighlighterKt.styledSpan(text, style);
            if (htmlChunk == null) {
                TypeToBodyWithLinksVisitor.$$$reportNull$$$0(1);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk escaped(@Nls String text) {
            HtmlChunk htmlChunk = HtmlChunk.text((String)text);
            if (htmlChunk == null) {
                TypeToBodyWithLinksVisitor.$$$reportNull$$$0(2);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk className(@Nls String name2) {
            TypeEvalContext context = TypeEvalContext.userInitiated(this.myAnchor.getProject(), this.myAnchor.getContainingFile());
            HtmlChunk htmlChunk = PyDocumentationLink.toPossibleClass(name2, this.myAnchor, context);
            if (htmlChunk == null) {
                TypeToBodyWithLinksVisitor.$$$reportNull$$$0(3);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk styledExpression(@Nls String expressionText, @NotNull PyExpression expression) {
            if (expression == null) {
                TypeToBodyWithLinksVisitor.$$$reportNull$$$0(4);
            }
            HtmlChunk htmlChunk = PyDocSignaturesHighlighterKt.highlightExpressionText(expressionText, expression);
            if (htmlChunk == null) {
                TypeToBodyWithLinksVisitor.$$$reportNull$$$0(5);
            }
            return htmlChunk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeToBodyWithLinksVisitor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeToBodyWithLinksVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "styled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escaped";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "className";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "styledExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "styled";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "styledExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class TypeToPep484TypeHintVisitor
    extends TypeToStringVisitor {
        private TypeToPep484TypeHintVisitor() {
        }

        @Override
        protected boolean maxDepthExceeded() {
            return false;
        }

        @Override
        public void function(FunctionType function) {
            this.add(HtmlChunk.raw((String)"Callable["));
            Collection<TypeModel> parameters = function.parameters;
            if (parameters != null) {
                this.add(HtmlChunk.raw((String)"["));
                this.processList(parameters);
                this.add(HtmlChunk.raw((String)"]"));
            } else {
                this.add(HtmlChunk.raw((String)"..."));
            }
            this.add(HtmlChunk.raw((String)", "));
            function.returnType.accept(this);
            this.add(HtmlChunk.raw((String)"]"));
        }

        @Override
        public void param(ParamType param) {
            if (param.type != null) {
                param.type.accept(this);
            } else {
                this.add(HtmlChunk.raw((String)"Any"));
            }
        }

        @Override
        public void collectionOf(CollectionOf collectionOf) {
            this.typingGenericFormat(collectionOf);
        }
    }

    private static class TypeToStringVisitor
    extends TypeNameVisitor {
        private TypeToStringVisitor() {
        }

        @Override
        @NotNull
        protected HtmlChunk styled(@Nls String text, @NotNull TextAttributesKey style) {
            if (style == null) {
                TypeToStringVisitor.$$$reportNull$$$0(0);
            }
            HtmlChunk htmlChunk = HtmlChunk.raw((String)text);
            if (htmlChunk == null) {
                TypeToStringVisitor.$$$reportNull$$$0(1);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk escaped(@Nls String text) {
            HtmlChunk htmlChunk = HtmlChunk.raw((String)text);
            if (htmlChunk == null) {
                TypeToStringVisitor.$$$reportNull$$$0(2);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk className(@Nls String name2) {
            HtmlChunk htmlChunk = this.escaped(name2);
            if (htmlChunk == null) {
                TypeToStringVisitor.$$$reportNull$$$0(3);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk styledExpression(@Nls String expressionText, @NotNull PyExpression expression) {
            if (expression == null) {
                TypeToStringVisitor.$$$reportNull$$$0(4);
            }
            HtmlChunk htmlChunk = HtmlChunk.raw((String)expressionText);
            if (htmlChunk == null) {
                TypeToStringVisitor.$$$reportNull$$$0(5);
            }
            return htmlChunk;
        }

        public String getString() {
            return this.myBody.toString();
        }

        @Override
        public void unknown(UnknownType type2) {
            TypeModel nested = type2.type;
            if (nested != null) {
                if (type2.bitwiseOrUnionAllowed) {
                    nested.accept(this);
                    this.add(HtmlChunk.raw((String)" | Any"));
                } else {
                    this.add(HtmlChunk.raw((String)"Union["));
                    nested.accept(this);
                    this.add(HtmlChunk.raw((String)", Any]"));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeToStringVisitor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeToStringVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "styled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escaped";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "className";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "styledExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "styled";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "styledExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static interface TypeVisitor {
        public void oneOf(OneOf var1);

        public void collectionOf(CollectionOf var1);

        public void name(String var1);

        public void function(FunctionType var1);

        public void param(ParamType var1);

        public void unknown(UnknownType var1);

        public void optional(OptionalType var1);

        public void tuple(TupleType var1);

        public void classObject(ClassObjectType var1);

        public void genericType(GenericType var1);

        public void oneOfLiterals(OneOfLiterals var1);
    }
}

