/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.transport.BaseDebuggerReader;
import com.jetbrains.python.debugger.pydev.transport.BaseDebuggerTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientModeDebuggerTransport
extends BaseDebuggerTransport {
    private static final Logger LOG = Logger.getInstance(ClientModeDebuggerTransport.class);
    private static final int CONNECTION_TIMEOUT_IN_MILLIS = 5000;
    private static final int HANDSHAKE_TIMEOUT_IN_MILLIS = 5000;
    @NotNull
    private final String myHost;
    private final int myPort;
    @NotNull
    private volatile State myState;
    @Nullable
    private Socket mySocket;
    @Nullable
    private volatile DebuggerReader myDebuggerReader;

    public ClientModeDebuggerTransport(@NotNull RemoteDebugger debugger, @NotNull String host, int port) {
        if (debugger == null) {
            ClientModeDebuggerTransport.$$$reportNull$$$0(0);
        }
        if (host == null) {
            ClientModeDebuggerTransport.$$$reportNull$$$0(1);
        }
        super(debugger);
        this.myState = State.INIT;
        this.myHost = host;
        this.myPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForConnect() throws IOException {
        if (this.myState != State.INIT) {
            throw new IllegalStateException("Inappropriate state of Python debugger for connecting to Python debugger: " + this.myState + "; " + State.INIT + " is expected");
        }
        boolean connected = false;
        try {
            DebuggerReader debuggerReader;
            Socket clientSocket = new Socket();
            clientSocket.setSoTimeout(5000);
            clientSocket.connect(new InetSocketAddress(this.myHost, this.myPort), 5000);
            Object object = this.mySocketObject;
            synchronized (object) {
                this.mySocket = clientSocket;
                this.myState = State.CONNECTED;
            }
            try {
                this.myDebuggerReader = debuggerReader = new DebuggerReader(this.myDebugger, clientSocket.getInputStream());
            }
            catch (IOException e) {
                LOG.debug("Failed to create debugger reader", (Throwable)e);
                throw e;
            }
            try {
                this.myDebugger.handshake();
                debuggerReader.connectionApproved();
                connected = true;
                clientSocket.setSoTimeout(0);
            }
            catch (PyDebuggerException e) {
                LOG.debug(String.format("[%d] Handshake failed", this.hashCode()));
            }
            finally {
                if (!connected) {
                    debuggerReader.close();
                }
            }
        }
        catch (ConnectException | SocketTimeoutException e) {
            this.myState = State.DISCONNECTED;
            throw new IOException("Failed to connect to debugger script", e);
        }
        if (!connected) {
            this.myState = State.DISCONNECTED;
            throw new IOException("Failed to connect to debugger script");
        }
        this.myState = State.APPROVED;
        LOG.debug(String.format("[%d] Connected to debugger script", this.hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean sendMessageImpl(byte[] packed) throws IOException {
        Object object = this.mySocketObject;
        synchronized (object) {
            if (this.mySocket == null || this.mySocket.isClosed()) {
                return false;
            }
            OutputStream os = this.mySocket.getOutputStream();
            os.write(packed);
            os.flush();
            return true;
        }
    }

    @Override
    protected void onSocketException() {
        this.myDebugger.disconnect();
        if (this.myState == State.APPROVED) {
            this.myDebugger.fireCommunicationError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            DebuggerReader debuggerReader = this.myDebuggerReader;
            if (debuggerReader != null) {
                debuggerReader.stop();
            }
        }
        finally {
            Object object = this.mySocketObject;
            synchronized (object) {
                if (this.mySocket != null) {
                    try {
                        this.mySocket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public boolean isConnecting() {
        return this.myState == State.CONNECTED;
    }

    @Override
    public boolean isConnected() {
        return this.myState == State.APPROVED;
    }

    @Override
    public void disconnect() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "debugger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "host";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/debugger/pydev/transport/ClientModeDebuggerTransport";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum State {
        INIT,
        CONNECTED,
        APPROVED,
        DISCONNECTED;

    }

    public static class DebuggerReader
    extends BaseDebuggerReader {
        private final AtomicBoolean myConnectionApproved;

        public DebuggerReader(@NotNull RemoteDebugger debugger, @NotNull InputStream stream) {
            if (debugger == null) {
                DebuggerReader.$$$reportNull$$$0(0);
            }
            if (stream == null) {
                DebuggerReader.$$$reportNull$$$0(1);
            }
            super(stream, StandardCharsets.UTF_8, debugger);
            this.myConnectionApproved = new AtomicBoolean(false);
            this.start(((Object)((Object)this)).getClass().getName());
        }

        @Override
        protected void onExit() {
            if (this.myConnectionApproved.get()) {
                this.getDebugger().fireExitEvent();
            }
        }

        @Override
        protected void onCommunicationError() {
            if (this.myConnectionApproved.get()) {
                this.getDebugger().fireCommunicationError();
            }
        }

        public void connectionApproved() {
            this.myConnectionApproved.set(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "debugger";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/pydev/transport/ClientModeDebuggerTransport$DebuggerReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

