/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.ArrayChunkBuilder;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyIo;
import com.jetbrains.python.debugger.PyLockEvent;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PyThreadEvent;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.values.DataFrameDebugValue;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParser;

public final class ProtocolParser {
    public static final String DUMMY_RET_VAL = "_dummy_ret_val";
    public static final String DUMMY_IPYTHON_HIDDEN = "_dummy_ipython_val";
    public static final String DUMMY_SPECIAL_VAR = "_dummy_special_var";
    public static final Set<String> HIDDEN_TYPES = Set.of("_dummy_ret_val", "_dummy_ipython_val", "_dummy_special_var");

    private ProtocolParser() {
    }

    public static PySignature parseCallSignature(String payload) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(payload, true);
        reader.moveDown();
        if (!"call_signature".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <call_signature>, found " + reader.getNodeName());
        }
        String file = reader.getAttribute("file");
        if (file == null) {
            file = "";
        }
        String name2 = ProtocolParser.readString(reader, "name", "");
        PySignature signature = new PySignature(file, name2);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("arg".equals(reader.getNodeName())) {
                signature.addArgument(ProtocolParser.readString(reader, "name", ""), ProtocolParser.readString(reader, "type", ""));
            } else if ("return".equals(reader.getNodeName())) {
                signature.addReturnType(ProtocolParser.readString(reader, "type", ""));
            } else {
                throw new PyDebuggerException("Expected <arg> or <return>, found " + reader.getNodeName());
            }
            reader.moveUp();
        }
        return signature;
    }

    public static PyConcurrencyEvent parseConcurrencyEvent(String payload, PyPositionConverter positionConverter) throws PyDebuggerException {
        PyConcurrencyEvent threadingEvent;
        boolean isAsyncio;
        XppReader reader = ProtocolParser.openReader(payload, true);
        reader.moveDown();
        String eventName = reader.getNodeName();
        if (eventName.equals("threading_event")) {
            isAsyncio = false;
        } else if (eventName.equals("asyncio_event")) {
            isAsyncio = true;
        } else {
            throw new PyDebuggerException("Expected <threading_event> or <asyncio_event>, found " + reader.getNodeName());
        }
        long time = Long.parseLong(ProtocolParser.readString(reader, "time", ""));
        String name2 = ProtocolParser.readString(reader, "name", "");
        String thread_id = ProtocolParser.readString(reader, "thread_id", "");
        String type2 = ProtocolParser.readString(reader, "type", "");
        if (type2.equals("lock")) {
            String lock_id = ProtocolParser.readString(reader, "lock_id", "0");
            threadingEvent = new PyLockEvent(time, thread_id, name2, lock_id, isAsyncio);
        } else if (type2.equals("thread")) {
            String parentThread = ProtocolParser.readString(reader, "parent", "");
            threadingEvent = !parentThread.isEmpty() ? new PyThreadEvent(time, thread_id, name2, parentThread, isAsyncio) : new PyThreadEvent((Long)time, thread_id, name2, isAsyncio);
        } else {
            throw new PyDebuggerException("Unknown type " + type2);
        }
        String eventType = ProtocolParser.readString(reader, "event", "");
        if (eventType.equals("__init__")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.CREATE);
        } else if (eventType.equals("start")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.START);
        } else if (eventType.equals("join")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.JOIN);
        } else if (eventType.equals("stop")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.STOP);
        } else if (eventType.equals("acquire_begin") || eventType.equals("__enter___begin") || eventType.equals("get_begin") || eventType.equals("put_begin")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.ACQUIRE_BEGIN);
        } else if (eventType.equals("acquire_end") || eventType.equals("__enter___end") || eventType.equals("get_end") || eventType.equals("put_end")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.ACQUIRE_END);
        } else if (eventType.startsWith("release") || eventType.startsWith("__exit__")) {
            threadingEvent.setType(PyConcurrencyEvent.EventType.RELEASE);
        } else {
            throw new PyDebuggerException("Unknown event " + eventType);
        }
        threadingEvent.setFileName(ProtocolParser.readString(reader, "file", ""));
        threadingEvent.setLine(Integer.parseInt(ProtocolParser.readString(reader, "line", "")) - 1);
        reader.moveUp();
        LinkedList<PyStackFrameInfo> frames = new LinkedList<PyStackFrameInfo>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            frames.add(ProtocolParser.parseFrame(reader, thread_id, positionConverter));
            reader.moveUp();
        }
        threadingEvent.setFrames(frames);
        return threadingEvent;
    }

    public static boolean parseInputCommand(String payload) {
        return payload.equals("True");
    }

    public static Pair<Boolean, String> parseSetNextStatementCommand(String payload) throws PyDebuggerException {
        String[] values = payload.split("\t");
        if (values.length > 0) {
            boolean success = values[0].equals("True");
            Object errorMessage = "Error";
            if (values.length > 1) {
                errorMessage = (String)errorMessage + ": " + values[1];
            }
            return new Pair((Object)success, errorMessage);
        }
        throw new PyDebuggerException("Unable to parse value: " + payload);
    }

    public static String parseSourceContent(String payload) {
        return payload;
    }

    public static String encodeExpression(String expression) {
        return StringUtil.replace((String)expression, (String)"\n", (String)"@LINE@");
    }

    public static PyIo parseIo(String text) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text, true);
        reader.moveDown();
        if (!"io".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <io>, found " + reader.getNodeName());
        }
        String s = ProtocolParser.readString(reader, "s", "");
        int ctx = ProtocolParser.readInt(reader, "ctx", 1);
        return new PyIo(s, ctx);
    }

    @NotNull
    public static PyThreadInfo parseThread(String text, PyPositionConverter positionConverter) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text, true);
        reader.moveDown();
        if (!"thread".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <thread>, found " + reader.getNodeName());
        }
        String id = ProtocolParser.readString(reader, "id", null);
        String name2 = ProtocolParser.readString(reader, "name", "");
        int stopReason = ProtocolParser.readInt(reader, "stop_reason", 0);
        String message = ProtocolParser.readString(reader, "message", "None");
        if ("None".equals(message) || message.isEmpty()) {
            message = null;
        }
        LinkedList<PyStackFrameInfo> frames = new LinkedList<PyStackFrameInfo>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            frames.add(ProtocolParser.parseFrame(reader, id, positionConverter));
            reader.moveUp();
        }
        return new PyThreadInfo(id, name2, frames, stopReason, message);
    }

    @NotNull
    public static String getThreadId(@NotNull String payload) {
        if (payload == null) {
            ProtocolParser.$$$reportNull$$$0(0);
        }
        String string = payload.split("\t")[0];
        if (string == null) {
            ProtocolParser.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static PyStackFrameInfo parseFrame(XppReader reader, String threadId, PyPositionConverter positionConverter) throws PyDebuggerException {
        if (!"frame".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <frame>, found " + reader.getNodeName());
        }
        String id = ProtocolParser.readString(reader, "id", null);
        String name2 = ProtocolParser.readString(reader, "name", null);
        String file = reader.getAttribute("file");
        int line2 = ProtocolParser.readInt(reader, "line", 0);
        return new PyStackFrameInfo(threadId, id, name2, positionConverter.convertPythonToFrame(file, line2));
    }

    @NotNull
    public static PyDebugValue parseValue(String text, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text, true);
        reader.moveDown();
        PyDebugValue pyDebugValue = ProtocolParser.parseValue(reader, frameAccessor);
        if (pyDebugValue == null) {
            ProtocolParser.$$$reportNull$$$0(2);
        }
        return pyDebugValue;
    }

    @NotNull
    public static List<PyDebugValue> parseReferrers(String text, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        LinkedList<PyDebugValue> values = new LinkedList<PyDebugValue>();
        XppReader reader = ProtocolParser.openReader(text, false);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("var")) {
                PyDebugValue value = ProtocolParser.parseValue(reader, frameAccessor);
                value.setId(ProtocolParser.readString(reader, "id", null));
                values.add(value);
            } else if (!reader.getNodeName().equals("for")) {
                throw new PyDebuggerException("Expected <var> or <for>, found " + reader.getNodeName());
            }
            reader.moveUp();
        }
        LinkedList<PyDebugValue> linkedList = values;
        if (linkedList == null) {
            ProtocolParser.$$$reportNull$$$0(3);
        }
        return linkedList;
    }

    @NotNull
    public static List<PyDebugValue> parseValues(String text, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        LinkedList<PyDebugValue> values = new LinkedList<PyDebugValue>();
        XppReader reader = ProtocolParser.openReader(text, false);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            values.add(ProtocolParser.parseValue(reader, frameAccessor));
            reader.moveUp();
        }
        LinkedList<PyDebugValue> linkedList = values;
        if (linkedList == null) {
            ProtocolParser.$$$reportNull$$$0(4);
        }
        return linkedList;
    }

    private static PyDebugValue parseValue(XppReader reader, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        if (!"var".equals(reader.getNodeName())) {
            throw new PyDebuggerException("Expected <var>, found " + reader.getNodeName());
        }
        String name2 = ProtocolParser.readString(reader, "name", null);
        String isErrorOnEval = ProtocolParser.readString(reader, "isErrorOnEval", "");
        if (HIDDEN_TYPES.contains(name2)) {
            return new PyDebugValue(name2, null, "", "", false, null, false, false, "True".equals(isErrorOnEval), null, frameAccessor);
        }
        String type2 = ProtocolParser.readString(reader, "type", null);
        String qualifier = ProtocolParser.readString(reader, "qualifier", "");
        String value = ProtocolParser.readString(reader, "value", null);
        String isContainer = ProtocolParser.readString(reader, "isContainer", "");
        String isReturnedValue = ProtocolParser.readString(reader, "isRetVal", "");
        String isIPythonHidden = ProtocolParser.readString(reader, "isIPythonHidden", "");
        String typeRendererId = ProtocolParser.readString(reader, "typeRendererId", "");
        String shape = ProtocolParser.readString(reader, "shape", "");
        if (value.startsWith(type2 + ": ")) {
            value = value.substring(type2.length() + 2);
        }
        if (shape.isEmpty()) {
            shape = null;
        }
        if (typeRendererId.isEmpty()) {
            typeRendererId = null;
        }
        if (type2.equals("DataFrame")) {
            return new DataFrameDebugValue(name2, type2, qualifier, value, "True".equals(isContainer), shape, "True".equals(isReturnedValue), "True".equals(isIPythonHidden), "True".equals(isErrorOnEval), typeRendererId, frameAccessor);
        }
        return new PyDebugValue(name2, type2, qualifier, value, "True".equals(isContainer), shape, "True".equals(isReturnedValue), "True".equals(isIPythonHidden), "True".equals(isErrorOnEval), typeRendererId, frameAccessor);
    }

    public static ArrayChunk parseArrayValues(String text, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text, false);
        ArrayChunkBuilder result2 = new ArrayChunkBuilder();
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"array".equals(reader.getNodeName())) {
                throw new PyDebuggerException("Expected <array> at first node, found " + reader.getNodeName());
            }
            String slice = ProtocolParser.readString(reader, "slice", null);
            result2.setSlicePresentation(slice);
            result2.setRows(ProtocolParser.readInt(reader, "rows", null));
            result2.setColumns(ProtocolParser.readInt(reader, "cols", null));
            result2.setFormat("%" + ProtocolParser.readString(reader, "format", null));
            result2.setType(ProtocolParser.readString(reader, "type", null));
            result2.setMax(ProtocolParser.readString(reader, "max", null));
            result2.setMin(ProtocolParser.readString(reader, "min", null));
            result2.setValue(new PyDebugValue(slice, null, null, null, false, null, false, false, false, null, frameAccessor));
            reader.moveUp();
        }
        if ("headerdata".equals(reader.peekNextChild())) {
            ProtocolParser.parseArrayHeaderData(reader, result2);
        }
        Object[][] data = ProtocolParser.parseArrayValues(reader, frameAccessor);
        result2.setData(data);
        return result2.createArrayChunk();
    }

    @NotNull
    public static List<Pair<String, Boolean>> parseSmartStepIntoVariants(String text) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text, false);
        ArrayList<Pair<String, Boolean>> variants = new ArrayList<Pair<String, Boolean>>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String variantName = ProtocolParser.read(reader, "name", true);
            Boolean isVisited = ProtocolParser.read(reader, "isVisited", true).equals("true");
            variants.add((Pair<String, Boolean>)Pair.create((Object)variantName, (Object)isVisited));
            reader.moveUp();
        }
        ArrayList<Pair<String, Boolean>> arrayList = variants;
        if (arrayList == null) {
            ProtocolParser.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void parseArrayHeaderData(XppReader reader, ArrayChunkBuilder result2) throws PyDebuggerException {
        ArrayList<String> rowHeaders = new ArrayList<String>();
        ArrayList<ArrayChunk.ColHeader> colHeaders = new ArrayList<ArrayChunk.ColHeader>();
        reader.moveDown();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("colheader".equals(reader.getNodeName())) {
                colHeaders.add(new ArrayChunk.ColHeader(ProtocolParser.readString(reader, "label", null), ProtocolParser.readString(reader, "type", null), ProtocolParser.readString(reader, "format", null), ProtocolParser.readString(reader, "max", null), ProtocolParser.readString(reader, "min", null)));
            } else if ("rowheader".equals(reader.getNodeName())) {
                rowHeaders.add(ProtocolParser.readString(reader, "label", null));
            } else {
                throw new PyDebuggerException("Invalid node name" + reader.getNodeName());
            }
            reader.moveUp();
        }
        result2.setColHeaders(colHeaders);
        result2.setRowLabels(rowHeaders);
        reader.moveUp();
    }

    public static Object[][] parseArrayValues(XppReader reader, PyFrameAccessor frameAccessor) throws PyDebuggerException {
        int rows = -1;
        int cols = -1;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"arraydata".equals(reader.getNodeName())) {
                throw new PyDebuggerException("Expected <arraydata> at second node, found " + reader.getNodeName());
            }
            rows = ProtocolParser.readInt(reader, "rows", null);
            cols = ProtocolParser.readInt(reader, "cols", null);
            reader.moveUp();
        }
        if (rows <= 0 || cols <= 0) {
            return null;
        }
        Object[][] values = new Object[rows][cols];
        int currRow = 0;
        int currCol = 0;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"var".equals(reader.getNodeName()) && !"row".equals(reader.getNodeName())) {
                throw new PyDebuggerException("Expected <var> or <row>, found " + reader.getNodeName());
            }
            if ("row".equals(reader.getNodeName())) {
                int index = ProtocolParser.readInt(reader, "index", null);
                if (currRow != index) {
                    throw new PyDebuggerException("Array xml: expected " + currRow + " row, found " + index);
                }
                if (currRow > 0 && currCol != cols) {
                    throw new PyDebuggerException("Array xml: expected " + cols + " filled columns, got " + currCol + " instead.");
                }
                ++currRow;
                currCol = 0;
            } else {
                PyDebugValue value = ProtocolParser.parseValue(reader, frameAccessor);
                values[currRow - 1][currCol] = value.getValue();
                ++currCol;
            }
            reader.moveUp();
        }
        return values;
    }

    public static String parseWarning(String text) throws PyDebuggerException {
        XppReader reader = ProtocolParser.openReader(text, true);
        reader.moveDown();
        return ProtocolParser.readString(reader, "id", null);
    }

    private static XppReader openReader(String text, boolean checkForContent) throws PyDebuggerException {
        XppReader reader = new XppReader((Reader)new StringReader(text), (XmlPullParser)new MXParser(), (NameCoder)new NoNameCoder());
        if (checkForContent && !reader.hasMoreChildren()) {
            throw new PyDebuggerException("Empty frame: " + text);
        }
        return reader;
    }

    private static String readString(XppReader reader, String name2, String fallback) throws PyDebuggerException {
        String value = ProtocolParser.read(reader, name2, fallback == null);
        return value == null ? fallback : value;
    }

    private static int readInt(XppReader reader, String name2, Integer fallback) throws PyDebuggerException {
        String value = ProtocolParser.read(reader, name2, fallback == null);
        if (value == null) {
            return fallback;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new PyDebuggerException("Unable to decode " + value + ": " + e.getMessage());
        }
    }

    @Contract(value="_, _, true -> !null")
    private static String read(XppReader reader, String name2, boolean isRequired) throws PyDebuggerException {
        String value = reader.getAttribute(name2);
        if (value == null && isRequired) {
            throw new PyDebuggerException("Attribute not found: " + name2);
        }
        return value == null ? null : URLUtil.decode((String)value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/ProtocolParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/ProtocolParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReferrers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSmartStepIntoVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThreadId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

