/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PySetNextStatementAction;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/debugger/PySetNextStatementAction;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerActionBase;", "()V", "setNextStatementActionHandler", "Lcom/intellij/xdebugger/impl/actions/XDebuggerSuspendedActionHandler;", "getHandler", "debuggerSupport", "Lcom/intellij/xdebugger/impl/DebuggerSupport;", "isHidden", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.python.community.impl"})
public final class PySetNextStatementAction
extends XDebuggerActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebuggerSuspendedActionHandler setNextStatementActionHandler = new XDebuggerSuspendedActionHandler(){

        protected void perform(@NotNull XDebugSession session, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            XDebugProcess xDebugProcess = session.getDebugProcess();
            PyDebugProcess pyDebugProcess = xDebugProcess instanceof PyDebugProcess ? (PyDebugProcess)xDebugProcess : null;
            if (pyDebugProcess == null) {
                return;
            }
            PyDebugProcess debugProcess = pyDebugProcess;
            XSourcePosition xSourcePosition = XDebuggerUtilImpl.getCaretPosition((Project)session.getProject(), (DataContext)dataContext);
            if (xSourcePosition == null) {
                return;
            }
            XSourcePosition position = xSourcePosition;
            Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (editor2 == null) {
                editor2 = FileEditorManager.getInstance((Project)session.getProject()).getSelectedTextEditor();
            }
            Editor editor3 = editor2;
            XSuspendContext suspendContext = debugProcess.getSession().getSuspendContext();
            ApplicationManager.getApplication().executeOnPooledThread(() -> 1.perform$lambda$0(debugProcess, suspendContext, position, editor3));
        }

        public boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return super.isEnabled(project, event) && PyDebugSupportUtils.isCurrentPythonDebugProcess(event);
        }

        private static final void perform$lambda$0(PyDebugProcess $debugProcess, XSuspendContext $suspendContext, XSourcePosition $position, Editor $editor) {
            Intrinsics.checkNotNullParameter((Object)$debugProcess, (String)"$debugProcess");
            Intrinsics.checkNotNullParameter((Object)$position, (String)"$position");
            $debugProcess.startSetNextStatement($suspendContext, $position, new PyDebugCallback<Pair<Boolean, String>>($editor, $position){
                final /* synthetic */ Editor $editor;
                final /* synthetic */ XSourcePosition $position;
                {
                    this.$editor = $editor;
                    this.$position = $position;
                }

                public void ok(@NotNull Pair<Boolean, String> response) {
                    Intrinsics.checkNotNullParameter(response, (String)"response");
                    if (!((Boolean)response.first).booleanValue() && this.$editor != null) {
                        ApplicationManager.getApplication().invokeLater(() -> perform.1.1.ok$lambda$0(this.$editor, this.$position, response), ModalityState.defaultModalityState());
                    }
                }

                public void error(@NotNull PyDebuggerException e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    PySetNextStatementAction.access$getLOG$cp().error((Throwable)e);
                }

                private static final void ok$lambda$0(Editor $editor, XSourcePosition $position, Pair $response) {
                    Intrinsics.checkNotNullParameter((Object)$position, (String)"$position");
                    Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
                    if (!$editor.isDisposed()) {
                        $editor.getCaretModel().moveToOffset($position.getOffset());
                        HintManager.getInstance().showErrorHint($editor, (String)$response.second);
                    }
                }
            });
        }
    };
    @NotNull
    private static final Logger LOG;

    public PySetNextStatementAction() {
        super(true);
    }

    @NotNull
    protected XDebuggerSuspendedActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        Intrinsics.checkNotNullParameter((Object)debuggerSupport, (String)"debuggerSupport");
        return this.setNextStatementActionHandler;
    }

    protected boolean isHidden(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        return project == null || !PyDebugSupportUtils.isCurrentPythonDebugProcess(event);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(PySetNextStatementAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(PySetNextStatementAction::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/debugger/PySetNextStatementAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

