/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleOptionsProvider;
import com.jetbrains.python.console.PyConsoleSpecificOptionsPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PyConsoleOptionsConfigurable
extends SearchableConfigurable.Parent.Abstract
implements Configurable.NoScroll {
    public static final String CONSOLE_SETTINGS_HELP_REFERENCE = "reference.project.settings.console";
    public static final String CONSOLE_SETTINGS_HELP_REFERENCE_PYTHON = "reference.project.settings.console.python";
    private PyConsoleOptionsPanel myPanel;
    private final Project myProject;

    public PyConsoleOptionsConfigurable(@NotNull Project project) {
        if (project == null) {
            PyConsoleOptionsConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        return "pyconsole";
    }

    protected Configurable[] buildConfigurables() {
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        PyConsoleSpecificOptionsPanel pythonConsoleOptionsPanel = new PyConsoleSpecificOptionsPanel(this.myProject);
        result2.add(PyConsoleOptionsConfigurable.createConsoleChildConfigurable(PyBundle.message("configurable.PyConsoleOptionsConfigurable.child.display.name", new Object[0]), pythonConsoleOptionsPanel, PyConsoleOptions.getInstance(this.myProject).getPythonConsoleSettings(), CONSOLE_SETTINGS_HELP_REFERENCE_PYTHON));
        for (PyConsoleOptionsProvider provider : PyConsoleOptionsProvider.EP_NAME.getExtensionList()) {
            if (!provider.isApplicableTo(this.myProject)) continue;
            result2.add(PyConsoleOptionsConfigurable.createConsoleChildConfigurable(provider.getName(), new PyConsoleSpecificOptionsPanel(this.myProject), provider.getSettings(this.myProject), provider.getHelpTopic()));
        }
        return result2.toArray(new Configurable[0]);
    }

    private static Configurable createConsoleChildConfigurable(final @NlsContexts.ConfigurableName String name2, final PyConsoleSpecificOptionsPanel panel2, final PyConsoleOptions.PyConsoleSettings settings, final String helpReference) {
        return new SearchableConfigurable(){

            @NotNull
            public String getId() {
                String string = "PyConsoleConfigurable." + name2;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nls
            public String getDisplayName() {
                return name2;
            }

            public String getHelpTopic() {
                return helpReference;
            }

            public JComponent createComponent() {
                return panel2.createPanel(settings);
            }

            public boolean isModified() {
                return panel2.isModified();
            }

            public void apply() {
                panel2.apply();
            }

            public void reset() {
                panel2.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PyConsoleOptionsConfigurable$1", "getId"));
            }
        };
    }

    @Nls
    public String getDisplayName() {
        return PyBundle.message("configurable.PyConsoleOptionsConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return CONSOLE_SETTINGS_HELP_REFERENCE;
    }

    public JComponent createComponent() {
        this.myPanel = new PyConsoleOptionsPanel();
        return this.myPanel.createPanel(PyConsoleOptions.getInstance(this.myProject));
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() {
        this.myPanel.apply();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/console/PyConsoleOptionsConfigurable", "<init>"));
    }

    private static class PyConsoleOptionsPanel {
        private JPanel myWholePanel;
        private JBCheckBox myShowDebugConsoleByDefault;
        private JBCheckBox myIpythonEnabledCheckbox;
        private JBCheckBox myShowsVariablesByDefault;
        private JBCheckBox myUseExistingConsole;
        private JBCheckBox myCommandQueueEnabledCheckbox;
        private JBCheckBox myAutoCompletionEnabledCheckbox;
        private PyConsoleOptions myOptionsProvider;

        private PyConsoleOptionsPanel() {
            this.$$$setupUI$$$();
        }

        public JPanel createPanel(PyConsoleOptions optionsProvider) {
            this.myOptionsProvider = optionsProvider;
            return this.myWholePanel;
        }

        public void apply() {
            this.myOptionsProvider.setShowDebugConsoleByDefault(this.myShowDebugConsoleByDefault.isSelected());
            this.myOptionsProvider.setIpythonEnabled(this.myIpythonEnabledCheckbox.isSelected());
            this.myOptionsProvider.setShowVariablesByDefault(this.myShowsVariablesByDefault.isSelected());
            this.myOptionsProvider.setUseExistingConsole(this.myUseExistingConsole.isSelected());
            this.myOptionsProvider.setCommandQueueEnabled(this.myCommandQueueEnabledCheckbox.isSelected());
            this.myOptionsProvider.setAutoCompletionEnabled(this.myAutoCompletionEnabledCheckbox.isSelected());
        }

        public void reset() {
            this.myShowDebugConsoleByDefault.setSelected(this.myOptionsProvider.isShowDebugConsoleByDefault());
            this.myIpythonEnabledCheckbox.setSelected(this.myOptionsProvider.isIpythonEnabled());
            this.myShowsVariablesByDefault.setSelected(this.myOptionsProvider.isShowVariableByDefault());
            this.myUseExistingConsole.setSelected(this.myOptionsProvider.isUseExistingConsole());
            this.myCommandQueueEnabledCheckbox.setSelected(this.myOptionsProvider.isCommandQueueEnabled());
            this.myAutoCompletionEnabledCheckbox.setSelected(this.myOptionsProvider.isAutoCompletionEnabled());
        }

        public boolean isModified() {
            return this.myShowDebugConsoleByDefault.isSelected() != this.myOptionsProvider.isShowDebugConsoleByDefault() || this.myIpythonEnabledCheckbox.isSelected() != this.myOptionsProvider.isIpythonEnabled() || this.myShowsVariablesByDefault.isSelected() != this.myOptionsProvider.isShowVariableByDefault() || this.myUseExistingConsole.isSelected() != this.myOptionsProvider.isUseExistingConsole() || this.myCommandQueueEnabledCheckbox.isSelected() != this.myOptionsProvider.isCommandQueueEnabled() || this.myAutoCompletionEnabledCheckbox.isSelected() != this.myOptionsProvider.isAutoCompletionEnabled();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JBCheckBox jBCheckBox3;
            JBCheckBox jBCheckBox4;
            JBCheckBox jBCheckBox5;
            JBCheckBox jBCheckBox6;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PyBundle", PyConsoleOptionsPanel.class).getString("form.console.options.settings.title.system.settings"), (int)0, (int)0, null, null));
            this.myShowDebugConsoleByDefault = jBCheckBox6 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/PyBundle", PyConsoleOptionsPanel.class).getString("form.console.options.always.show.debug.console"));
            jPanel2.add((Component)jBCheckBox6, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel2.add((Component)spacer2, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myIpythonEnabledCheckbox = jBCheckBox5 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/PyBundle", PyConsoleOptionsPanel.class).getString("form.console.options.use.ipython.if.available"));
            jPanel2.add((Component)jBCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myShowsVariablesByDefault = jBCheckBox4 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/PyBundle", PyConsoleOptionsPanel.class).getString("form.console.options.show.console.variables.by.default"));
            jPanel2.add((Component)jBCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myUseExistingConsole = jBCheckBox3 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/PyBundle", PyConsoleOptionsPanel.class).getString("form.console.options.use.existing.console.for.run.with.python.console"));
            jPanel2.add((Component)jBCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myCommandQueueEnabledCheckbox = jBCheckBox2 = new JBCheckBox();
            jBCheckBox2.setSelected(true);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PyBundle", PyConsoleOptionsPanel.class).getString("form.console.options.use.command.queue"));
            jPanel2.add((Component)jBCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myAutoCompletionEnabledCheckbox = jBCheckBox = new JBCheckBox();
            jBCheckBox.setSelected(false);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", PyConsoleOptionsPanel.class).getString("form.console.options.auto.completion.enabled"));
            jBCheckBox.setToolTipText("");
            jPanel2.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

