/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.PythonHelpersLocator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class PyStdlibUtil {
    @Nullable
    private static final Set<String> PACKAGES = PyStdlibUtil.loadStdlibPackagesList();

    private PyStdlibUtil() {
    }

    @Nullable
    public static Collection<String> getPackages() {
        return PACKAGES;
    }

    @Nullable
    private static Set<String> loadStdlibPackagesList() {
        Set<String> set;
        Logger log = Logger.getInstance((String)PyStdlibUtil.class.getName());
        String helperPath = PythonHelpersLocator.getHelperPath("/tools/stdlib_packages.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(helperPath), StandardCharsets.UTF_8));
        try {
            set = reader.lines().collect(Collectors.toSet());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Cannot read list of standard library packages: " + e.getMessage());
                return null;
            }
        }
        reader.close();
        return set;
    }
}

