/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public final class PyMatchStatementFixer
extends PyFixer<PyStatement> {
    public PyMatchStatementFixer() {
        super(PyStatement.class);
    }

    @Override
    protected void doApply(@NotNull Editor editor2, @NotNull PySmartEnterProcessor processor2, @NotNull PyStatement element) {
        PyAnnotation annotation;
        if (editor2 == null) {
            PyMatchStatementFixer.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            PyMatchStatementFixer.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PyMatchStatementFixer.$$$reportNull$$$0(2);
        }
        Document document = editor2.getDocument();
        PyMatchStatement matchStatement = PyUtil.as(element, PyMatchStatement.class);
        if (matchStatement != null) {
            boolean hasEmptyBody;
            PsiElement colon = PyPsiUtils.getFirstChildOfType((PsiElement)element, PyTokenTypes.COLON);
            assert (colon != null);
            int colonEndOffset = colon.getTextRange().getEndOffset();
            boolean bl = hasEmptyBody = colonEndOffset == matchStatement.getTextRange().getEndOffset();
            if (hasEmptyBody) {
                String matchIndent = PyIndentUtil.getElementIndent((PsiElement)element);
                String indent = PyIndentUtil.getIndentFromSettings(element.getContainingFile());
                String caseClausePlaceholder = "\n" + matchIndent + indent + "case :";
                document.insertString(colonEndOffset, (CharSequence)caseClausePlaceholder);
                processor2.registerUnresolvedError(colonEndOffset + caseClausePlaceholder.length() - 1);
            }
            return;
        }
        PyTypeDeclarationStatement typeDeclaration = PyUtil.as(element, PyTypeDeclarationStatement.class);
        if (typeDeclaration != null && PyMatchStatementFixer.isMatchIdentifier((PsiElement)typeDeclaration.getTarget()) && (annotation = typeDeclaration.getAnnotation()) != null && annotation.getValue() == null) {
            processor2.registerUnresolvedError(annotation.getTextRange().getStartOffset());
            return;
        }
        Couple<PsiElement> pair = PyMatchStatementFixer.findMatchKeywordAndSubjectInExpressionStatement(element);
        PsiElement matchKeyword = (PsiElement)pair.getFirst();
        if (matchKeyword == null) {
            return;
        }
        PsiElement subject = (PsiElement)pair.getSecond();
        if (subject != null) {
            int endOffset = subject.getTextRange().getEndOffset();
            String matchIndent = PyIndentUtil.getElementIndent(matchKeyword);
            String indent = PyIndentUtil.getIndentFromSettings(element.getContainingFile());
            String caseClausePlaceholder = ":\n" + matchIndent + indent + "case :";
            document.insertString(endOffset, (CharSequence)caseClausePlaceholder);
            processor2.registerUnresolvedError(endOffset + caseClausePlaceholder.length() - 1);
        } else {
            int endOffset = element.getTextRange().getEndOffset();
            document.insertString(endOffset, (CharSequence)" :");
            processor2.registerUnresolvedError(endOffset + 1);
        }
    }

    @NotNull
    private static Couple<PsiElement> findMatchKeywordAndSubjectInExpressionStatement(@NotNull PyStatement statement) {
        if (statement == null) {
            PyMatchStatementFixer.$$$reportNull$$$0(3);
        }
        if (!(statement instanceof PyExpressionStatement)) {
            Couple couple = Couple.getEmpty();
            if (couple == null) {
                PyMatchStatementFixer.$$$reportNull$$$0(4);
            }
            return couple;
        }
        PsiElement prevSibling = PyPsiUtils.getPrevNonWhitespaceSiblingOnSameLine((PsiElement)statement);
        if (prevSibling instanceof PyExpressionStatement && PyMatchStatementFixer.isMatchIdentifier(prevSibling)) {
            Couple couple = Couple.of((Object)prevSibling, (Object)statement);
            if (couple == null) {
                PyMatchStatementFixer.$$$reportNull$$$0(5);
            }
            return couple;
        }
        if (PyMatchStatementFixer.isMatchIdentifier((PsiElement)statement)) {
            PsiElement nextSibling = PyPsiUtils.getNextNonWhitespaceSiblingOnSameLine((PsiElement)statement);
            if (nextSibling instanceof PyExpressionStatement) {
                Couple couple = Couple.of((Object)statement, (Object)nextSibling);
                if (couple == null) {
                    PyMatchStatementFixer.$$$reportNull$$$0(6);
                }
                return couple;
            }
            if (nextSibling == null) {
                Couple couple = Couple.of((Object)statement, null);
                if (couple == null) {
                    PyMatchStatementFixer.$$$reportNull$$$0(7);
                }
                return couple;
            }
        }
        if (PyMatchStatementFixer.isMatchIdentifier(PsiTreeUtil.getDeepestFirst((PsiElement)statement))) {
            Couple couple;
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)statement);
            PyElementGenerator generator = PyElementGenerator.getInstance(statement.getProject());
            String subjectSuspect = StringUtil.trimStart((String)statement.getText(), (String)"match");
            try {
                generator.createExpressionFromText(languageLevel, subjectSuspect.trim());
                couple = Couple.of((Object)statement, (Object)statement);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (couple == null) {
                PyMatchStatementFixer.$$$reportNull$$$0(8);
            }
            return couple;
        }
        Couple couple = Couple.getEmpty();
        if (couple == null) {
            PyMatchStatementFixer.$$$reportNull$$$0(9);
        }
        return couple;
    }

    private static boolean isMatchIdentifier(@NotNull PsiElement element) {
        if (element == null) {
            PyMatchStatementFixer.$$$reportNull$$$0(10);
        }
        return element.getText().equals("match");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyMatchStatementFixer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyMatchStatementFixer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatchKeywordAndSubjectInExpressionStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doApply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findMatchKeywordAndSubjectInExpressionStatement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMatchIdentifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

