/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.InstructionTypeCallback;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeAssertionEvaluator
extends PyRecursiveElementVisitor {
    private final Stack<Assertion> myStack = new Stack();
    private boolean myPositive;

    public PyTypeAssertionEvaluator() {
        this(true);
    }

    public PyTypeAssertionEvaluator(boolean positive) {
        this.myPositive = positive;
    }

    public List<Assertion> getDefinitions() {
        return this.myStack;
    }

    @Override
    public void visitPyPrefixExpression(@NotNull PyPrefixExpression node) {
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(0);
        }
        if (node.getOperator() == PyTokenTypes.NOT_KEYWORD) {
            this.myPositive = !this.myPositive;
            super.visitPyPrefixExpression(node);
            this.myPositive = !this.myPositive;
        } else {
            super.visitPyPrefixExpression(node);
        }
    }

    @Override
    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        PyExpression typeElement2;
        PyExpression[] args2;
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(1);
        }
        if (node.isCalleeText("isinstance", "assertIsInstance")) {
            PyExpression pyExpression;
            PyExpression[] args3 = node.getArguments();
            if (args3.length == 2 && (pyExpression = args3[0]) instanceof PyReferenceExpression) {
                PyReferenceExpression target = (PyReferenceExpression)pyExpression;
                PyExpression typeElement2 = args3[1];
                this.pushAssertion(target, this.myPositive, false, context -> context.getType(typeElement2), typeElement2);
            }
        } else if (node.isCalleeText("callable")) {
            PyExpression typeElement2;
            PyExpression[] args4 = node.getArguments();
            if (args4.length == 1 && (typeElement2 = args4[0]) instanceof PyReferenceExpression) {
                PyReferenceExpression target = (PyReferenceExpression)typeElement2;
                this.pushAssertion(target, this.myPositive, false, context -> PyTypingTypeProvider.createTypingCallableType((PsiElement)node), null);
            }
        } else if (node.isCalleeText("issubclass") && (args2 = node.getArguments()).length == 2 && (typeElement2 = args2[0]) instanceof PyReferenceExpression) {
            PyReferenceExpression target = (PyReferenceExpression)typeElement2;
            typeElement2 = args2[1];
            this.pushAssertion(target, this.myPositive, true, context -> context.getType(typeElement2), typeElement2);
        }
    }

    @Override
    public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(2);
        }
        if (this.myPositive && (PyTypeAssertionEvaluator.isIfReferenceStatement(node) || PyTypeAssertionEvaluator.isIfReferenceConditionalStatement(node) || PyTypeAssertionEvaluator.isIfNotReferenceStatement(node))) {
            this.pushAssertion(node, !this.myPositive, false, context -> PyNoneType.INSTANCE, null);
            return;
        }
        super.visitPyReferenceExpression(node);
    }

    @Override
    public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(3);
        }
        PyExpression lhs = node.getLeftExpression();
        PyExpression rhs = node.getRightExpression();
        if (lhs instanceof PyReferenceExpression && rhs instanceof PyReferenceExpression || lhs instanceof PyReferenceExpression && rhs instanceof PyNoneLiteralExpression || lhs instanceof PyNoneLiteralExpression && rhs instanceof PyReferenceExpression) {
            boolean rightIsNone;
            boolean leftIsNone = lhs instanceof PyNoneLiteralExpression || "None".equals(lhs.getName());
            boolean bl = rightIsNone = rhs instanceof PyNoneLiteralExpression || "None".equals(rhs.getName());
            if (leftIsNone ^ rightIsNone) {
                PyReferenceExpression target = (PyReferenceExpression)(rightIsNone ? lhs : rhs);
                if (node.isOperator("is")) {
                    this.pushAssertion(target, this.myPositive, false, context -> PyNoneType.INSTANCE, null);
                    return;
                }
                if (node.isOperator("isnot")) {
                    this.pushAssertion(target, !this.myPositive, false, context -> PyNoneType.INSTANCE, null);
                    return;
                }
            }
        }
        Object leftValue = PyEvaluator.evaluateNoResolve(lhs, Object.class);
        Object rightValue = PyEvaluator.evaluateNoResolve(rhs, Object.class);
        if (leftValue instanceof Boolean && rightValue instanceof Boolean) {
            return;
        }
        if (node.isOperator("is") && (leftValue == Boolean.FALSE || rightValue == Boolean.FALSE) || node.isOperator("isnot") && (leftValue == Boolean.TRUE || rightValue == Boolean.TRUE)) {
            this.myPositive = !this.myPositive;
            super.visitPyBinaryExpression(node);
            this.myPositive = !this.myPositive;
            return;
        }
        super.visitPyBinaryExpression(node);
    }

    @Nullable
    private static Ref<PyType> createAssertionType(@Nullable PyType initial, @Nullable PyType suggested, boolean positive, boolean transformToDefinition, @NotNull TypeEvalContext context, @Nullable PyExpression typeElement) {
        if (context == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(4);
        }
        PyType transformedType = PyTypeAssertionEvaluator.transformTypeFromAssertion(suggested, transformToDefinition, context, typeElement);
        if (positive) {
            if (!(initial instanceof PyUnionType) && !(initial instanceof PyStructuralType) && !PyTypeChecker.isUnknown(initial, context) && PyTypeChecker.match(transformedType, initial, context)) {
                return Ref.create((Object)initial);
            }
            return Ref.create((Object)transformedType);
        }
        if (initial instanceof PyUnionType) {
            return Ref.create((Object)((PyUnionType)initial).exclude(transformedType, context));
        }
        if (!(initial instanceof PyStructuralType) && !PyTypeChecker.isUnknown(initial, context) && PyTypeChecker.match(transformedType, initial, context)) {
            return null;
        }
        return Ref.create((Object)initial);
    }

    @Nullable
    private static PyType transformTypeFromAssertion(@Nullable PyType type2, boolean transformToDefinition, @NotNull TypeEvalContext context, @Nullable PyExpression typeElement) {
        if (context == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(5);
        }
        if (type2 instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)type2;
            ArrayList<PyType> members2 = new ArrayList<PyType>();
            int count = tupleType.getElementCount();
            PyTupleExpression tupleExpression = PyUtil.as(PyPsiUtils.flattenParens(PyUtil.as(typeElement, PyParenthesizedExpression.class)), PyTupleExpression.class);
            if (tupleExpression != null && tupleExpression.getElements().length == count) {
                PyExpression[] elements = tupleExpression.getElements();
                for (int i = 0; i < count; ++i) {
                    members2.add(PyTypeAssertionEvaluator.transformTypeFromAssertion(tupleType.getElementType(i), transformToDefinition, context, elements[i]));
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    members2.add(PyTypeAssertionEvaluator.transformTypeFromAssertion(tupleType.getElementType(i), transformToDefinition, context, null));
                }
            }
            return PyUnionType.union(members2);
        }
        if (type2 instanceof PyUnionType) {
            return ((PyUnionType)type2).map(member -> PyTypeAssertionEvaluator.transformTypeFromAssertion(member, transformToDefinition, context, null));
        }
        if (type2 instanceof PyClassType && "types.UnionType".equals(((PyClassType)type2).getClassQName()) && typeElement != null) {
            Ref<PyType> typeFromTypingProvider = PyTypingTypeProvider.getType(typeElement, context);
            if (typeFromTypingProvider != null) {
                return PyTypeAssertionEvaluator.transformTypeFromAssertion((PyType)typeFromTypingProvider.get(), transformToDefinition, context, null);
            }
        } else if (type2 instanceof PyInstantiableType) {
            PyInstantiableType instantiableType = (PyInstantiableType)type2;
            return transformToDefinition ? instantiableType.toClass() : instantiableType.toInstance();
        }
        return type2;
    }

    private void pushAssertion(final @NotNull PyReferenceExpression target, final boolean positive, final boolean transformToDefinition, final @NotNull Function<TypeEvalContext, PyType> suggestedType, final @Nullable PyExpression typeElement) {
        if (target == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(6);
        }
        if (suggestedType == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(7);
        }
        InstructionTypeCallback typeCallback = new InstructionTypeCallback(){

            @Override
            public Ref<PyType> getType(TypeEvalContext context, @Nullable PsiElement anchor) {
                return PyTypeAssertionEvaluator.createAssertionType(context.getType(target), (PyType)suggestedType.apply(context), positive, transformToDefinition, context, typeElement);
            }
        };
        this.myStack.push((Object)new Assertion(target, typeCallback));
    }

    private static boolean isIfReferenceStatement(@NotNull PyReferenceExpression node) {
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(8);
        }
        return node.getParent() instanceof PyIfPart;
    }

    private static boolean isIfReferenceConditionalStatement(@NotNull PyReferenceExpression node) {
        PsiElement parent;
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(9);
        }
        return (parent = node.getParent()) instanceof PyConditionalExpression && node == ((PyConditionalExpression)parent).getCondition();
    }

    private static boolean isIfNotReferenceStatement(@NotNull PyReferenceExpression node) {
        PsiElement parent;
        if (node == null) {
            PyTypeAssertionEvaluator.$$$reportNull$$$0(10);
        }
        return (parent = node.getParent()) instanceof PyPrefixExpression && ((PyPrefixExpression)parent).getOperator() == PyTokenTypes.NOT_KEYWORD && parent.getParent() instanceof PyIfPart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedType";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyTypeAssertionEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyPrefixExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyCallExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyReferenceExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyBinaryExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createAssertionType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "transformTypeFromAssertion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "pushAssertion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isIfReferenceStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isIfReferenceConditionalStatement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isIfNotReferenceStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Assertion {
        private final PyReferenceExpression element;
        private final InstructionTypeCallback myFunction;

        Assertion(PyReferenceExpression element, InstructionTypeCallback getType) {
            this.element = element;
            this.myFunction = getType;
        }

        public PyReferenceExpression getElement() {
            return this.element;
        }

        public InstructionTypeCallback getTypeEvalFunction() {
            return this.myFunction;
        }
    }
}

