/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import javax.swing.JLabel;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.BasicComponentPrinter;
import org.assertj.swing.core.ComponentFinder;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.core.ComponentPrinter;
import org.assertj.swing.core.FinderDelegate;
import org.assertj.swing.core.GenericTypeMatcher;
import org.assertj.swing.core.LabelMatcher;
import org.assertj.swing.core.NameMatcher;
import org.assertj.swing.core.Settings;
import org.assertj.swing.core.TypeMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ComponentLookupException;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.hierarchy.ComponentHierarchy;
import org.assertj.swing.hierarchy.ExistingHierarchy;
import org.assertj.swing.hierarchy.NewHierarchy;
import org.assertj.swing.hierarchy.SingleComponentHierarchy;

public final class BasicComponentFinder
implements ComponentFinder {
    private final ComponentHierarchy hierarchy;
    private final ComponentPrinter printer;
    private final Settings settings;
    private final FinderDelegate finderDelegate = new FinderDelegate();
    private boolean includeHierarchyInComponentLookupException;

    @Nonnull
    public static ComponentFinder finderWithNewAwtHierarchy() {
        return new BasicComponentFinder(NewHierarchy.ignoreExistingComponents());
    }

    @Nonnull
    public static ComponentFinder finderWithCurrentAwtHierarchy() {
        return new BasicComponentFinder(new ExistingHierarchy());
    }

    protected BasicComponentFinder(@Nonnull ComponentHierarchy hierarchy) {
        this(hierarchy, null);
    }

    protected BasicComponentFinder(@Nonnull ComponentHierarchy hierarchy, @Nullable Settings settings) {
        this.hierarchy = hierarchy;
        this.settings = settings;
        this.printer = new BasicComponentPrinter(hierarchy);
        this.includeHierarchyIfComponentNotFound(true);
    }

    @Override
    @Nonnull
    public ComponentPrinter printer() {
        return this.printer;
    }

    @Override
    @Nonnull
    public <T extends Component> T findByType(@Nonnull Class<T> type2) {
        return this.findByType(type2, this.requireShowing());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByType(@Nonnull Class<T> type2, boolean showing) {
        return (T)((Component)type2.cast(this.find(new TypeMatcher(type2, showing))));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByType(@Nonnull Container root, @Nonnull Class<T> type2) {
        return this.findByType(root, type2, this.requireShowing());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByType(@Nonnull Container root, @Nonnull Class<T> type2, boolean showing) {
        return (T)((Component)type2.cast(this.find(root, (ComponentMatcher)new TypeMatcher(type2, showing))));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByName(@Nullable String name, @Nonnull Class<T> type2) {
        return this.findByName(name, type2, this.requireShowing());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByName(@Nullable String name, @Nonnull Class<T> type2, boolean showing) {
        Component found = this.find(new NameMatcher(name, type2, showing));
        return (T)((Component)type2.cast(found));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByName(@Nullable String name) {
        return this.findByName(name, this.requireShowing());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByName(@Nullable String name, boolean showing) {
        return this.find(new NameMatcher(name, showing));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByLabel(@Nullable String label, @Nonnull Class<T> type2) {
        return this.findByLabel(label, type2, this.requireShowing());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByLabel(@Nullable String label, @Nonnull Class<T> type2, boolean showing) {
        Component found = this.find(new LabelMatcher(label, type2, showing));
        return (T)((Component)this.labelFor(found, type2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByLabel(@Nullable String label) {
        return this.findByLabel(label, this.requireShowing());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByLabel(@Nullable String label, boolean showing) {
        Component found = this.find(new LabelMatcher(label, showing));
        return this.labelFor(found, Component.class);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T find(@Nonnull GenericTypeMatcher<T> m) {
        Component found = this.find((ComponentMatcher)m);
        return (T)((Component)m.supportedType().cast(found));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component find(@Nonnull ComponentMatcher m) {
        return this.find(this.hierarchy, m);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByName(@Nonnull Container root, @Nullable String name, @Nonnull Class<T> type2) {
        return this.findByName(root, name, type2, this.requireShowing());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByName(@Nonnull Container root, @Nullable String name, @Nonnull Class<T> type2, boolean showing) {
        Component found = this.find(root, (ComponentMatcher)new NameMatcher(name, type2, showing));
        return (T)((Component)type2.cast(found));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByName(@Nonnull Container root, @Nullable String name) {
        return this.findByName(root, name, this.requireShowing());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByName(@Nonnull Container root, @Nullable String name, boolean showing) {
        return this.find(root, (ComponentMatcher)new NameMatcher(name, showing));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByLabel(@Nonnull Container root, @Nullable String label, @Nonnull Class<T> type2) {
        return this.findByLabel(root, label, type2, this.requireShowing());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByLabel(@Nonnull Container root, @Nullable String label, @Nonnull Class<T> type2, boolean showing) {
        Component found = this.find(root, (ComponentMatcher)new LabelMatcher(label, type2, showing));
        return (T)((Component)this.labelFor(found, type2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByLabel(@Nonnull Container root, @Nullable String label) {
        return this.findByLabel(root, label, this.requireShowing());
    }

    private boolean requireShowing() {
        return this.requireShowingFromSettingsOr(false);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByLabel(@Nonnull Container root, @Nullable String label, boolean showing) {
        Component found = this.find(root, (ComponentMatcher)new LabelMatcher(label, showing));
        return this.labelFor(found, Component.class);
    }

    @Nonnull
    private <T> T labelFor(@Nonnull Component label, @Nonnull Class<T> type2) {
        ((AbstractAssert)((Object)Assertions.assertThat(label))).isInstanceOf((Class)JLabel.class);
        Component target = ((JLabel)label).getLabelFor();
        ((AbstractAssert)((Object)Assertions.assertThat(target))).isInstanceOf((Class)type2);
        return type2.cast(target);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T find(@Nonnull Container root, @Nonnull GenericTypeMatcher<T> m) {
        Component found = this.find(root, (ComponentMatcher)m);
        return (T)((Component)m.supportedType().cast(found));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component find(@Nullable Container root, @Nonnull ComponentMatcher m) {
        return this.find(this.hierarchy(root), m);
    }

    @Nonnull
    @RunsInEDT
    private Component find(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m) {
        Collection<Component> found = this.finderDelegate.find(h, m);
        if (found.isEmpty()) {
            throw this.componentNotFound(h, m);
        }
        if (found.size() > 1) {
            throw BasicComponentFinder.multipleComponentsFound(found, m);
        }
        return Preconditions.checkNotNull(found.iterator().next());
    }

    @Nonnull
    @RunsInEDT
    private ComponentLookupException componentNotFound(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m) {
        String message = Strings.concat("Unable to find component using matcher ", m, ".");
        if (this.includeHierarchyIfComponentNotFound()) {
            message = Strings.concat(message, System.lineSeparator(), System.lineSeparator(), "Component hierarchy:", System.lineSeparator(), this.formattedHierarchy(BasicComponentFinder.root(h)));
        }
        throw new ComponentLookupException(message);
    }

    @Nullable
    private static Container root(@Nullable ComponentHierarchy h) {
        if (h instanceof SingleComponentHierarchy) {
            return ((SingleComponentHierarchy)h).root();
        }
        return null;
    }

    @Nonnull
    @RunsInEDT
    private String formattedHierarchy(@Nullable Container root) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out, true);
        this.printer.printComponents(printStream, root);
        printStream.flush();
        return new String(out.toByteArray());
    }

    @Nonnull
    @RunsInEDT
    private static ComponentLookupException multipleComponentsFound(@Nonnull Collection<Component> found, @Nonnull ComponentMatcher m) {
        StringBuilder message = new StringBuilder();
        String format = "Found more than one component using matcher %s. %n%nFound:";
        message.append(String.format(format, m.toString()));
        BasicComponentFinder.appendComponents(message, found);
        if (!found.isEmpty()) {
            message.append(System.lineSeparator());
        }
        throw new ComponentLookupException(message.toString(), found);
    }

    @RunsInEDT
    private static void appendComponents(@Nonnull StringBuilder message, @Nonnull Collection<Component> found) {
        GuiActionRunner.execute(() -> {
            for (Component c : found) {
                message.append(String.format("%n%s", Formatting.format(c)));
            }
        });
    }

    @Override
    public boolean includeHierarchyIfComponentNotFound() {
        return this.includeHierarchyInComponentLookupException;
    }

    @Override
    public void includeHierarchyIfComponentNotFound(boolean newValue) {
        this.includeHierarchyInComponentLookupException = newValue;
    }

    @Override
    @Nonnull
    public Collection<Component> findAll(@Nonnull ComponentMatcher m) {
        return this.finderDelegate.find(this.hierarchy, m);
    }

    @Override
    @Nonnull
    public Collection<Component> findAll(@Nonnull Container root, @Nonnull ComponentMatcher m) {
        return this.finderDelegate.find(this.hierarchy(root), m);
    }

    @Override
    @Nonnull
    public <T extends Component> Collection<T> findAll(@Nonnull GenericTypeMatcher<T> m) {
        return this.finderDelegate.find(this.hierarchy, m);
    }

    @Override
    @Nonnull
    public <T extends Component> Collection<T> findAll(@Nonnull Container root, @Nonnull GenericTypeMatcher<T> m) {
        ComponentHierarchy h = this.hierarchy(root);
        return this.finderDelegate.find(h, m);
    }

    protected final boolean requireShowingFromSettingsOr(boolean defaultValue) {
        if (this.settings == null) {
            return defaultValue;
        }
        return this.settings.componentLookupScope().requireShowing();
    }

    @Nonnull
    private ComponentHierarchy hierarchy(@Nullable Container root) {
        if (root == null) {
            return this.hierarchy;
        }
        return new SingleComponentHierarchy(root, this.hierarchy);
    }
}

