/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import java.util.Iterator;
import java.util.List;

class Simplifier
extends AbstractVisitor {
    public static void simplify(SchemaCollection schemaCollection) {
        Simplifier simplifier = new Simplifier();
        Iterator iterator = schemaCollection.getSchemaDocumentMap().values().iterator();
        while (iterator.hasNext()) {
            SchemaDocument schemaDocument = (SchemaDocument)iterator.next();
            schemaDocument.setPattern((Pattern)schemaDocument.getPattern().accept(simplifier));
        }
    }

    private Simplifier() {
    }

    public Object visitGrammar(GrammarPattern grammarPattern) {
        return this.visitContainer(grammarPattern);
    }

    public Object visitContainer(Container container) {
        List list = container.getComponents();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            ((Component)list.get(n)).accept(this);
            ++n;
        }
        return container;
    }

    public Object visitInclude(IncludeComponent includeComponent) {
        return this.visitContainer(includeComponent);
    }

    public Object visitDiv(DivComponent divComponent) {
        return this.visitContainer(divComponent);
    }

    public Object visitDefine(DefineComponent defineComponent) {
        defineComponent.setBody((Pattern)defineComponent.getBody().accept(this));
        return defineComponent;
    }

    public Object visitChoice(ChoicePattern choicePattern) {
        Pattern pattern2;
        boolean bl = false;
        List list = choicePattern.getChildren();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            list.set(n, ((Pattern)list.get(n)).accept(this));
            ++n;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            pattern2 = (Pattern)iterator.next();
            if (pattern2 instanceof NotAllowedPattern) {
                iterator.remove();
                continue;
            }
            if (!(pattern2 instanceof EmptyPattern)) continue;
            bl = true;
            iterator.remove();
        }
        if (list.size() == 0) {
            return Simplifier.copy(new NotAllowedPattern(), choicePattern);
        }
        pattern2 = list.size() == 1 ? (Pattern)list.get(0) : choicePattern;
        if (bl && !(pattern2 instanceof OptionalPattern) && !(pattern2 instanceof ZeroOrMorePattern)) {
            pattern2 = pattern2 instanceof OneOrMorePattern ? new ZeroOrMorePattern(((OneOrMorePattern)pattern2).getChild()) : new OptionalPattern(pattern2);
            Simplifier.copy(pattern2, choicePattern);
        }
        return pattern2;
    }

    public Object visitComposite(CompositePattern compositePattern) {
        List list = compositePattern.getChildren();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            list.set(n, ((Pattern)list.get(n)).accept(this));
            ++n;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Pattern pattern2 = (Pattern)iterator.next();
            if (!(pattern2 instanceof EmptyPattern)) continue;
            iterator.remove();
        }
        if (list.size() == 0) {
            return Simplifier.copy(new EmptyPattern(), compositePattern);
        }
        if (list.size() == 1) {
            return (Pattern)compositePattern.getChildren().get(0);
        }
        return compositePattern;
    }

    public Object visitInterleave(InterleavePattern interleavePattern) {
        boolean bl = false;
        Iterator iterator = interleavePattern.getChildren().iterator();
        while (iterator.hasNext()) {
            Pattern pattern2 = (Pattern)iterator.next();
            if (!(pattern2 instanceof TextPattern)) continue;
            iterator.remove();
            bl = true;
        }
        if (!bl) {
            return this.visitComposite(interleavePattern);
        }
        return Simplifier.copy(new MixedPattern((Pattern)this.visitComposite(interleavePattern)), interleavePattern);
    }

    public Object visitUnary(UnaryPattern unaryPattern) {
        unaryPattern.setChild((Pattern)unaryPattern.getChild().accept(this));
        return unaryPattern;
    }

    private static Annotated copy(Annotated annotated, Annotated annotated2) {
        annotated.setSourceLocation(annotated2.getSourceLocation());
        return annotated;
    }

    public Object visitPattern(Pattern pattern2) {
        return pattern2;
    }
}

