/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile oldFile = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (oldFile == null || !(oldFile.getFileType() instanceof LanguageFileType) || !((LanguageFileType)oldFile.getFileType()).getLanguage().isKindOf((Language)JsonLanguage.INSTANCE)) {
            return null;
        }
        final Project project2 = element.getProject();
        if (project2.getBaseDir() == null) {
            return null;
        }
        final String oldRelativePath = VfsUtilCore.getRelativePath((VirtualFile)oldFile, (VirtualFile)project2.getBaseDir());
        if (oldRelativePath != null) {
            final JsonSchemaMappingsProjectConfiguration configuration = JsonSchemaMappingsProjectConfiguration.getInstance(project2);
            return new UndoRefactoringElementAdapter(){

                protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
                    String newRelativePath;
                    VirtualFile newFile;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((newFile = PsiUtilBase.asVirtualFile((PsiElement)element)) != null && (newRelativePath = VfsUtilCore.getRelativePath((VirtualFile)newFile, (VirtualFile)project2.getBaseDir())) != null) {
                        configuration.schemaFileMoved(project2, oldRelativePath, newRelativePath);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/JsonSchemaRefactoringListenerProvider$1", "refactored"));
                }
            };
        }
        return null;
    }
}

