/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class AddDtdDeclarationFix
implements LocalQuickFix {
    @PropertyKey(resourceBundle="messages.XmlBundle")
    private final @PropertyKey(resourceBundle="messages.XmlBundle") String myMessageKey;
    private final String myElementDeclarationName;
    private final String myReference;

    public AddDtdDeclarationFix(@PropertyKey(resourceBundle="messages.XmlAnalysisBundle") @PropertyKey(resourceBundle="messages.XmlAnalysisBundle") String messageKey, @NotNull String elementDeclarationName, @NotNull PsiReference reference) {
        if (elementDeclarationName == null) {
            AddDtdDeclarationFix.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            AddDtdDeclarationFix.$$$reportNull$$$0(1);
        }
        this.myMessageKey = messageKey;
        this.myElementDeclarationName = elementDeclarationName;
        this.myReference = reference.getCanonicalText();
    }

    @NotNull
    public String getFamilyName() {
        String string2 = XmlAnalysisBundle.message(this.myMessageKey, this.myReference);
        if (string2 == null) {
            AddDtdDeclarationFix.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            AddDtdDeclarationFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AddDtdDeclarationFix.$$$reportNull$$$0(4);
        }
        PsiElement element = descriptor.getPsiElement();
        PsiFile containingFile = element.getContainingFile();
        @NonNls Object prefixToInsert = "";
        @NonNls Object suffixToInsert = "";
        int UNDEFINED_OFFSET = -1;
        int anchorOffset = -1;
        PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{XmlElementDecl.class, XmlAttlistDecl.class, XmlEntityDecl.class, XmlConditionalSection.class});
        if (anchor != null) {
            anchorOffset = anchor.getTextRange().getStartOffset();
        }
        if (anchorOffset == -1 && containingFile.getLanguage() == XMLLanguage.INSTANCE) {
            XmlFile file = (XmlFile)containingFile;
            XmlProlog prolog = file.getDocument().getProlog();
            assert (prolog != null);
            XmlDoctype doctype = prolog.getDoctype();
            XmlMarkupDecl markupDecl = doctype != null ? doctype.getMarkupDecl() : null;
            if (doctype == null) {
                XmlTag rootTag = file.getDocument().getRootTag();
                prefixToInsert = "<!DOCTYPE " + (rootTag != null ? rootTag.getName() : "null");
                suffixToInsert = ">\n";
            }
            if (markupDecl == null) {
                prefixToInsert = (String)prefixToInsert + " [\n";
                suffixToInsert = "]" + (String)suffixToInsert;
                anchorOffset = doctype != null ? doctype.getTextRange().getEndOffset() - 1 : prolog.getTextRange().getEndOffset();
            }
        }
        if (anchorOffset == -1) {
            anchorOffset = element.getTextRange().getStartOffset();
        }
        OpenFileDescriptor openDescriptor = new OpenFileDescriptor(project2, containingFile.getVirtualFile(), anchorOffset);
        Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(openDescriptor, true);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project2);
        Template t = templateManager.createTemplate("", "");
        if (!((String)prefixToInsert).isEmpty()) {
            t.addTextSegment((String)prefixToInsert);
        }
        t.addTextSegment("<!" + this.myElementDeclarationName + " " + this.myReference + " ");
        t.addEndVariable();
        t.addTextSegment(">\n");
        if (!((String)suffixToInsert).isEmpty()) {
            t.addTextSegment((String)suffixToInsert);
        }
        templateManager.startTemplate(editor, t);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDeclarationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/AddDtdDeclarationFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/AddDtdDeclarationFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

