/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.details.commit.ReferencesPanel;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.LabelPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TooltipReferencesPanel
extends ReferencesPanel {
    private static final int REFS_LIMIT = 10;
    private boolean myHasGroupWithMultipleRefs;

    TooltipReferencesPanel(@NotNull VcsLogData logData, @NotNull Collection<? extends VcsRef> refs) {
        if (logData == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(0);
        }
        if (refs == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new VerticalFlowLayout(JBUIScale.scale((int)4), JBUIScale.scale((int)0)), 10);
        VirtualFile root = Objects.requireNonNull((VcsRef)ContainerUtil.getFirstItem(refs)).getRoot();
        this.setReferences(ContainerUtil.sorted(refs, logData.getLogProvider(root).getReferenceManager().getLabelsOrderComparator()));
    }

    @Override
    public void update() {
        this.myHasGroupWithMultipleRefs = false;
        for (Map.Entry typeAndRefs : this.myGroupedVisibleReferences.entrySet()) {
            if (((Collection)typeAndRefs.getValue()).size() <= 1) continue;
            this.myHasGroupWithMultipleRefs = true;
            break;
        }
        super.update();
    }

    @Override
    @NotNull
    protected Font getLabelsFont() {
        Font font = LabelPainter.getReferenceFont();
        if (font == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(2);
        }
        return font;
    }

    @Override
    @Nullable
    protected Icon createIcon(@NotNull VcsRefType type2, @NotNull Collection<VcsRef> refs, int refIndex, int height) {
        if (type2 == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(3);
        }
        if (refs == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(4);
        }
        if (refIndex == 0) {
            Color color = type2.getBackgroundColor();
            return new LabelIcon(this, height, UIUtil.getToolTipBackground(), refs.size() > 1 ? List.of(color, color) : Collections.singletonList(color)){

                @Override
                public int getIconWidth() {
                    return this.getWidth(TooltipReferencesPanel.this.myHasGroupWithMultipleRefs ? 2 : 1);
                }
            };
        }
        return TooltipReferencesPanel.createEmptyIcon(height);
    }

    @NotNull
    private static Icon createEmptyIcon(int height) {
        EmptyIcon emptyIcon = EmptyIcon.create((int)LabelIcon.getWidth(height, 2), (int)height);
        if (emptyIcon == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(5);
        }
        return emptyIcon;
    }

    @Override
    @NotNull
    protected JBLabel createLabel(@Nls @NotNull String text2, @Nullable Icon icon2) {
        if (text2 == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(6);
        }
        JBLabel label = super.createLabel(text2, icon2);
        label.setForeground(UIUtil.getToolTipForeground());
        JBLabel jBLabel = label;
        if (jBLabel == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(7);
        }
        return jBLabel;
    }

    @Override
    @NotNull
    protected JBLabel createRestLabel(int restSize) {
        String gray = ColorUtil.toHex((Color)UIManager.getColor("Button.disabledText"));
        String labelText = VcsLogBundle.message("vcs.log.references.more.tooltip", restSize);
        String html = HtmlChunk.text((String)labelText).wrapWith("font").attr("color", "#" + gray).wrapWith(HtmlChunk.html()).toString();
        JBLabel jBLabel = this.createLabel(html, TooltipReferencesPanel.createEmptyIcon(this.getIconHeight()));
        if (jBLabel == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(8);
        }
        return jBLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/render/TooltipReferencesPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/render/TooltipReferencesPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsFont";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRestLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 5, 7, 8 -> new IllegalStateException(string2);
        };
    }
}

